/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource.assembler;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.DistributionTargetResource;
import pro.taskana.rest.resource.assembler.DistributionTargetAssembler;

@Component
public class DistributionTargetListAssembler {
    @Autowired
    private DistributionTargetAssembler distributionTargetAssembler;

    public Resources<DistributionTargetResource> toResource(String workbasketId, Collection<WorkbasketSummary> distributionTargets) throws WorkbasketNotFoundException, NotAuthorizedException {
        ArrayList<DistributionTargetResource> resourceList = new ArrayList<DistributionTargetResource>();
        for (WorkbasketSummary wb : distributionTargets) {
            resourceList.add(this.distributionTargetAssembler.toResource(wb));
        }
        Resources distributionTargetListResource = new Resources(resourceList, new Link[0]);
        distributionTargetListResource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getDistributionTargets(workbasketId)).withSelfRel());
        distributionTargetListResource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasket(workbasketId)).withRel("workbasket"));
        return distributionTargetListResource;
    }
}

