/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource.assembler;

import org.springframework.beans.BeanUtils;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import pro.taskana.TaskSummary;
import pro.taskana.rest.TaskController;
import pro.taskana.rest.resource.TaskSummaryResource;
import pro.taskana.rest.resource.assembler.ClassificationSummaryResourceAssembler;
import pro.taskana.rest.resource.assembler.WorkbasketSummaryResourceAssembler;

public class TaskSummaryResourceAssembler
extends ResourceAssemblerSupport<TaskSummary, TaskSummaryResource> {
    private WorkbasketSummaryResourceAssembler workbasketAssembler = new WorkbasketSummaryResourceAssembler();
    private ClassificationSummaryResourceAssembler classificationAssembler = new ClassificationSummaryResourceAssembler();

    public TaskSummaryResourceAssembler() {
        super(TaskController.class, TaskSummaryResource.class);
    }

    public TaskSummaryResource toResource(TaskSummary taskSummary) {
        TaskSummaryResource resource = (TaskSummaryResource)this.createResourceWithId(taskSummary.getTaskId(), taskSummary);
        BeanUtils.copyProperties((Object)taskSummary, (Object)((Object)resource));
        if (taskSummary.getCreated() != null) {
            resource.setCreated(taskSummary.getCreated().toString());
        }
        if (taskSummary.getModified() != null) {
            resource.setModified(taskSummary.getModified().toString());
        }
        if (taskSummary.getClaimed() != null) {
            resource.setClaimed(taskSummary.getClaimed().toString());
        }
        if (taskSummary.getCompleted() != null) {
            resource.setCompleted(taskSummary.getCompleted().toString());
        }
        if (taskSummary.getDue() != null) {
            resource.setDue(taskSummary.getDue().toString());
        }
        resource.setClassificationSummaryResource(this.classificationAssembler.toResource(taskSummary.getClassificationSummary()));
        resource.setWorkbasketSummaryResource(this.workbasketAssembler.toResource(taskSummary.getWorkbasketSummary()));
        return resource;
    }
}

