/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.ldap;

import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.ldap.filter.WhitespaceWildcardsFilter;
import org.springframework.stereotype.Component;
import pro.taskana.exceptions.SystemException;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.rest.resource.AccessIdResource;

@Component
public class LdapClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapClient.class);
    private boolean active = false;
    @Autowired
    private Environment env;
    @Autowired
    private LdapTemplate ldapTemplate;
    private String userSearchBase;
    private String userSearchFilterName;
    private String userSearchFilterValue;
    private String userFirstnameAttribute;
    private String userLastnameAttribute;
    private String groupSearchBase;
    private String groupSearchFilterName;
    private String groupSearchFilterValue;
    private String groupNameAttribute;
    private static final String CN = "cn";
    private String message;

    @PostConstruct
    private void init() {
        if (this.useLdap()) {
            this.userSearchBase = this.getUserSearchBase();
            this.userSearchFilterName = this.getUserSearchFilterName();
            this.userSearchFilterValue = this.getUserSearchFilterValue();
            this.userFirstnameAttribute = this.getUserFirstnameAttribute();
            this.userLastnameAttribute = this.getUserLastnameAttribute();
            this.groupSearchBase = this.getGroupSearchBase();
            this.groupSearchFilterName = this.getGroupSearchFilterName();
            this.groupSearchFilterValue = this.getGroupSearchFilterValue();
            this.groupNameAttribute = this.getGroupNameAttribute();
            this.message = "taskana.ldap.useLdap is set to true, but";
            if (this.userSearchBase == null) {
                this.message = this.message + " taskana.ldap.userSearchBase is not configured.";
            }
            if (this.userSearchFilterName == null) {
                this.message = this.message + " taskana.ldap.userSearchFilterName is not configured.";
            }
            if (this.userSearchFilterValue == null) {
                this.message = this.message + " taskana.ldap.userSearchFilterValue is not configured.";
            }
            if (this.userFirstnameAttribute == null) {
                this.message = this.message + " taskana.ldap.userFirstnameAttribute is not configured.";
            }
            if (this.userLastnameAttribute == null) {
                this.message = this.message + " taskana.ldap.userLastnameAttribute is not configured.";
            }
            if (this.groupSearchBase == null) {
                this.message = this.message + " taskana.ldap.groupSearchBase is not configured.";
            }
            if (this.groupSearchFilterName == null) {
                this.message = this.message + " taskana.ldap.groupSearchFilterName is not configured.";
            }
            if (this.groupSearchFilterValue == null) {
                this.message = this.message + " taskana.ldap.groupSearchFilterValue is not configured.";
            }
            if (this.groupNameAttribute == null) {
                this.message = this.message + " taskana.ldap.groupNameAttribute is not configured.";
            }
            if (!this.message.equals("taskana.ldap.useLdap is set to true, but")) {
                LOGGER.error("Ldap configuration error detected: {}", (Object)this.message);
                throw new SystemException(this.message);
            }
            this.active = true;
        }
    }

    public List<AccessIdResource> searchUsersAndGroups(String name) {
        LOGGER.debug("entry to searchUsersAndGroups(name = {})", (Object)name);
        if (!this.active) {
            LOGGER.error("LdapClient was called but is not active due to missing configuration: " + this.message);
            throw new SystemException("LdapClient was called but is not active due to missing configuration: " + this.message);
        }
        List<AccessIdResource> users = this.searchUsersByName(name);
        users.addAll(this.searchGroupsByName(name));
        LOGGER.debug("exit from searchUsersAndGroups(name = {}). Found {} users and groups.", (Object)name, (Object)users.size());
        return users;
    }

    public List<AccessIdResource> searchUsersByName(String name) {
        LOGGER.debug("entry to searchUsersByName(name = {}).", (Object)name);
        if (!this.active) {
            LOGGER.error("LdapClient was called but is not active due to missing configuration: " + this.message);
            throw new SystemException("LdapClient was called but is not active due to missing configuration: " + this.message);
        }
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getUserSearchFilterName(), this.getUserSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new WhitespaceWildcardsFilter(CN, name));
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserFirstnameAttribute(), name));
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserLastnameAttribute(), name));
        andFilter.and((Filter)orFilter);
        String[] userAttributesToReturn = new String[]{this.getUserFirstnameAttribute(), this.getUserLastnameAttribute(), CN};
        try {
            List accessIds = this.ldapTemplate.search(this.getUserSearchBase(), andFilter.encode(), 2, userAttributesToReturn, (ContextMapper)new UserContextMapper());
            LOGGER.debug("exit from searchUsersByName. Retrieved the following users: {}.", (Object)LoggerUtils.listToString((List)accessIds));
            return accessIds;
        }
        catch (Exception e) {
            LOGGER.error("caught Exception {} ", (Object)e.getMessage());
            throw e;
        }
    }

    public List<AccessIdResource> searchGroupsByName(String name) {
        LOGGER.debug("entry to searchGroupsByName(name = {}).", (Object)name);
        if (!this.active) {
            LOGGER.error("LdapClient was called but is not active due to missing configuration: " + this.message);
            throw new SystemException("LdapClient was called but is not active due to missing configuration: " + this.message);
        }
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getGroupSearchFilterName(), this.getGroupSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getGroupNameAttribute(), name));
        if (!CN.equals(this.groupNameAttribute)) {
            orFilter.or((Filter)new WhitespaceWildcardsFilter(CN, name));
        }
        andFilter.and((Filter)orFilter);
        String[] groupAttributesToReturn = CN.equals(this.groupNameAttribute) ? new String[]{CN} : new String[]{this.getGroupNameAttribute(), CN};
        try {
            List accessIds = this.ldapTemplate.search(this.getGroupSearchBase(), andFilter.encode(), 2, groupAttributesToReturn, (ContextMapper)new GroupContextMapper());
            LOGGER.debug("Exit from searchGroupsByName. Retrieved the following groups: {}", (Object)LoggerUtils.listToString((List)accessIds));
            return accessIds;
        }
        catch (Exception e) {
            LOGGER.error("caught Exception {} ", (Object)e.getMessage());
            throw e;
        }
    }

    public boolean useLdap() {
        String useLdap = this.env.getProperty("taskana.ldap.useLdap");
        if (useLdap == null || useLdap.isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(useLdap);
    }

    public String getUserSearchBase() {
        return this.env.getProperty("taskana.ldap.userSearchBase");
    }

    public String getUserSearchFilterName() {
        return this.env.getProperty("taskana.ldap.userSearchFilterName");
    }

    public String getUserSearchFilterValue() {
        return this.env.getProperty("taskana.ldap.userSearchFilterValue");
    }

    public String getUserFirstnameAttribute() {
        return this.env.getProperty("taskana.ldap.userFirstnameAttribute");
    }

    public String getUserLastnameAttribute() {
        return this.env.getProperty("taskana.ldap.userLastnameAttribute");
    }

    public String getGroupSearchBase() {
        return this.env.getProperty("taskana.ldap.groupSearchBase");
    }

    public String getGroupSearchFilterName() {
        return this.env.getProperty("taskana.ldap.groupSearchFilterName");
    }

    public String getGroupSearchFilterValue() {
        return this.env.getProperty("taskana.ldap.groupSearchFilterValue");
    }

    public String getGroupNameAttribute() {
        return this.env.getProperty("taskana.ldap.groupNameAttribute");
    }

    private class GroupContextMapper
    extends AbstractContextMapper<AccessIdResource> {
        private GroupContextMapper() {
        }

        public AccessIdResource doMapFromContext(DirContextOperations context) {
            AccessIdResource accessId = new AccessIdResource();
            accessId.setAccessId(context.getNameInNamespace());
            accessId.setName(context.getStringAttribute(LdapClient.this.getGroupNameAttribute()));
            return accessId;
        }
    }

    private class UserContextMapper
    extends AbstractContextMapper<AccessIdResource> {
        private UserContextMapper() {
        }

        public AccessIdResource doMapFromContext(DirContextOperations context) {
            AccessIdResource accessId = new AccessIdResource();
            accessId.setAccessId(context.getNameInNamespace());
            String firstName = context.getStringAttribute(LdapClient.this.getUserFirstnameAttribute());
            String lastName = context.getStringAttribute(LdapClient.this.getUserLastnameAttribute());
            accessId.setName(lastName + ", " + firstName);
            return accessId;
        }
    }
}

