/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.DomainNotFoundException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.resource.WorkbasketAccessItemResource;
import pro.taskana.rest.resource.WorkbasketDefinition;
import pro.taskana.rest.resource.WorkbasketResource;
import pro.taskana.rest.resource.assembler.WorkbasketAccessItemAssembler;
import pro.taskana.rest.resource.assembler.WorkbasketAssembler;
import pro.taskana.rest.resource.assembler.WorkbasketDefinitionAssembler;

@RestController
@RequestMapping(path={"/v1/workbasketdefinitions"}, produces={"application/json"})
public class WorkbasketDefinitionController {
    @Autowired
    private WorkbasketService workbasketService;
    @Autowired
    private WorkbasketDefinitionAssembler workbasketDefinitionAssembler;
    @Autowired
    private WorkbasketAssembler workbasketAssembler;
    @Autowired
    private WorkbasketAccessItemAssembler workbasketAccessItemAssembler;

    @GetMapping
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<WorkbasketDefinition>> exportWorkbaskets(@RequestParam(required=false) String domain) {
        try {
            WorkbasketQuery workbasketQuery = this.workbasketService.createWorkbasketQuery();
            List workbasketSummaryList = domain != null ? workbasketQuery.domainIn(new String[]{domain}).list() : workbasketQuery.list();
            ArrayList<WorkbasketDefinition> basketExports = new ArrayList<WorkbasketDefinition>();
            for (WorkbasketSummary summary : workbasketSummaryList) {
                Workbasket workbasket = this.workbasketService.getWorkbasket(summary.getId());
                basketExports.add(this.workbasketDefinitionAssembler.toResource(workbasket));
            }
            return new ResponseEntity(basketExports, HttpStatus.OK);
        }
        catch (WorkbasketNotFoundException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (NotAuthorizedException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
    }

    @PostMapping(path={"/import"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<String> importWorkbaskets(@RequestBody List<WorkbasketDefinition> definitions) {
        try {
            Map<String, String> systemIds = this.workbasketService.createWorkbasketQuery().list().stream().collect(Collectors.toMap(this::logicalId, WorkbasketSummary::getId));
            HashMap<String, String> idConversion = new HashMap<String, String>();
            for (WorkbasketDefinition definition : definitions) {
                Workbasket workbasket;
                WorkbasketResource res = definition.workbasketResource;
                String oldId = res.workbasketId;
                if (systemIds.containsKey(this.logicalId(res))) {
                    res.workbasketId = systemIds.get(this.logicalId(res));
                    workbasket = this.workbasketService.updateWorkbasket(this.workbasketAssembler.toModel(res));
                } else {
                    res.workbasketId = null;
                    workbasket = this.workbasketService.createWorkbasket(this.workbasketAssembler.toModel(res));
                }
                res.workbasketId = oldId;
                for (WorkbasketAccessItem accessItem : this.workbasketService.getWorkbasketAccessItems(workbasket.getId())) {
                    this.workbasketService.deleteWorkbasketAccessItem(accessItem.getId());
                }
                for (WorkbasketAccessItemResource authorization : definition.authorizations) {
                    this.workbasketService.createWorkbasketAccessItem(this.workbasketAccessItemAssembler.toModel(authorization));
                }
                idConversion.put(definition.workbasketResource.workbasketId, workbasket.getId());
            }
            for (WorkbasketDefinition definition : definitions) {
                ArrayList distributionTargets = new ArrayList();
                for (String oldId : definition.distributionTargets) {
                    if (idConversion.containsKey(oldId)) {
                        distributionTargets.add(idConversion.get(oldId));
                        continue;
                    }
                    throw new InvalidWorkbasketException(String.format("invalid import state: Workbasket '%s' does not exist in the given import list", oldId));
                }
                this.workbasketService.setDistributionTargets((String)idConversion.get(definition.workbasketResource.workbasketId), distributionTargets);
            }
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (WorkbasketNotFoundException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (InvalidWorkbasketException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (NotAuthorizedException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        catch (InvalidArgumentException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity(HttpStatus.PRECONDITION_FAILED);
        }
        catch (WorkbasketAlreadyExistException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        catch (DomainNotFoundException e) {
            TransactionInterceptor.currentTransactionStatus().setRollbackOnly();
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    private String logicalId(WorkbasketSummary workbasket) {
        return this.logicalId(workbasket.getKey(), workbasket.getDomain());
    }

    private String logicalId(WorkbasketResource resource) {
        return this.logicalId(resource.key, resource.domain);
    }

    private String logicalId(String key, String domain) {
        return key + "|" + domain;
    }
}

