/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource.assembler;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.WorkbasketAccessItemResource;
import pro.taskana.rest.resource.assembler.WorkbasketAccessItemAssembler;

@Component
public class WorkbasketAccessItemListAssembler {
    @Autowired
    private WorkbasketAccessItemAssembler workbasketAccessItemAssembler;

    public Resources<WorkbasketAccessItemResource> toResource(String workbasketId, Collection<WorkbasketAccessItem> accessItems) throws NotAuthorizedException, WorkbasketNotFoundException {
        ArrayList<WorkbasketAccessItemResource> resourceList = new ArrayList<WorkbasketAccessItemResource>();
        for (WorkbasketAccessItem accessItem : accessItems) {
            resourceList.add(this.workbasketAccessItemAssembler.toResource(accessItem));
        }
        Resources accessItemListResource = new Resources(resourceList, new Link[0]);
        accessItemListResource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasketAccessItems(workbasketId)).withSelfRel());
        accessItemListResource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasket(workbasketId)).withRel("workbasket"));
        return accessItemListResource;
    }
}

