/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource.assembler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.WorkbasketDefinitionController;
import pro.taskana.rest.resource.WorkbasketAccessItemResource;
import pro.taskana.rest.resource.WorkbasketDefinition;
import pro.taskana.rest.resource.assembler.WorkbasketAccessItemAssembler;
import pro.taskana.rest.resource.assembler.WorkbasketAssembler;

@Component
public class WorkbasketDefinitionAssembler {
    @Autowired
    private WorkbasketService workbasketService;
    @Autowired
    private WorkbasketAssembler workbasketAssembler;
    @Autowired
    private WorkbasketAccessItemAssembler workbasketAccessItemAssembler;

    public WorkbasketDefinition toResource(Workbasket basket) throws NotAuthorizedException, WorkbasketNotFoundException {
        ArrayList<WorkbasketAccessItemResource> authorizations = new ArrayList<WorkbasketAccessItemResource>();
        for (WorkbasketAccessItem accessItem : this.workbasketService.getWorkbasketAccessItems(basket.getKey())) {
            authorizations.add(this.workbasketAccessItemAssembler.toResource(accessItem));
        }
        Set<String> distroTargets = this.workbasketService.getDistributionTargets(basket.getId()).stream().map(WorkbasketSummary::getId).collect(Collectors.toSet());
        WorkbasketDefinition resource = new WorkbasketDefinition(this.workbasketAssembler.toResource(basket), distroTargets, authorizations);
        return this.addLinks(resource, basket);
    }

    private WorkbasketDefinition addLinks(WorkbasketDefinition resource, Workbasket workbasket) {
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketDefinitionController)ControllerLinkBuilder.methodOn(WorkbasketDefinitionController.class, (Object[])new Object[0])).exportWorkbaskets(workbasket.getDomain())).withRel("exportWorkbaskets"));
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketDefinitionController)ControllerLinkBuilder.methodOn(WorkbasketDefinitionController.class, (Object[])new Object[0])).importWorkbaskets(Collections.singletonList(resource))).withRel("importWorkbaskets"));
        return resource;
    }
}

