/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.BaseQuery;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketPermission;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketSummary;
import pro.taskana.WorkbasketType;
import pro.taskana.exceptions.DomainNotFoundException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.exceptions.WorkbasketInUseException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.AbstractPagingController;
import pro.taskana.rest.resource.DistributionTargetResource;
import pro.taskana.rest.resource.WorkbasketAccessItemResource;
import pro.taskana.rest.resource.WorkbasketResource;
import pro.taskana.rest.resource.WorkbasketSummaryResource;
import pro.taskana.rest.resource.assembler.DistributionTargetListAssembler;
import pro.taskana.rest.resource.assembler.WorkbasketAccessItemAssembler;
import pro.taskana.rest.resource.assembler.WorkbasketAccessItemListAssembler;
import pro.taskana.rest.resource.assembler.WorkbasketAssembler;
import pro.taskana.rest.resource.assembler.WorkbasketSummaryResourcesAssembler;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@RequestMapping(path={"/v1/workbaskets"}, produces={"application/hal+json"})
public class WorkbasketController
extends AbstractPagingController {
    private static final String LIKE = "%";
    private static final String NAME = "name";
    private static final String NAME_LIKE = "name-like";
    private static final String KEY = "key";
    private static final String KEY_LIKE = "key-like";
    private static final String OWNER = "owner";
    private static final String OWNER_LIKE = "owner-like";
    private static final String DESCRIPTION_LIKE = "description-like";
    private static final String DOMAIN = "domain";
    private static final String REQUIRED_PERMISSION = "required-permission";
    private static final String TYPE = "type";
    private static final String DESCRIPTION = "description";
    private static final String SORT_BY = "sort-by";
    private static final String SORT_DIRECTION = "order";
    private static final String PAGING_PAGE = "page";
    private static final String PAGING_PAGE_SIZE = "page-size";
    @Autowired
    private WorkbasketService workbasketService;
    @Autowired
    private WorkbasketAssembler workbasketAssembler;
    @Autowired
    private DistributionTargetListAssembler distributionTargetListAssembler;
    @Autowired
    private WorkbasketAccessItemListAssembler accessItemListAssembler;
    @Autowired
    private WorkbasketAccessItemAssembler workbasketAccessItemAssembler;

    @GetMapping
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<PagedResources<WorkbasketSummaryResource>> getWorkbaskets(@RequestParam MultiValueMap<String, String> params) throws InvalidArgumentException {
        WorkbasketQuery query = this.workbasketService.createWorkbasketQuery();
        query = this.applySortingParams(query, params);
        query = this.applyFilterParams(query, params);
        PagedResources.PageMetadata pageMetadata = null;
        List workbasketSummaries = null;
        String page = (String)params.getFirst((Object)PAGING_PAGE);
        String pageSize = (String)params.getFirst((Object)PAGING_PAGE_SIZE);
        params.remove((Object)PAGING_PAGE);
        params.remove((Object)PAGING_PAGE_SIZE);
        this.validateNoInvalidParameterIsLeft(params);
        if (page != null && pageSize != null) {
            long totalElements = query.count();
            pageMetadata = this.initPageMetadata(pageSize, page, totalElements);
            workbasketSummaries = query.listPage((int)pageMetadata.getNumber(), (int)pageMetadata.getSize());
        } else if (page == null && pageSize == null) {
            workbasketSummaries = query.list();
        } else {
            throw new InvalidArgumentException("Paging information is incomplete.");
        }
        WorkbasketSummaryResourcesAssembler assembler = new WorkbasketSummaryResourcesAssembler();
        PagedResources<WorkbasketSummaryResource> pagedResources = assembler.toResources(workbasketSummaries, pageMetadata);
        return new ResponseEntity(pagedResources, HttpStatus.OK);
    }

    @GetMapping(path={"/{workbasketId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketResource> getWorkbasket(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        Workbasket workbasket = this.workbasketService.getWorkbasket(workbasketId);
        ResponseEntity result = new ResponseEntity((Object)this.workbasketAssembler.toResource(workbasket), HttpStatus.OK);
        return result;
    }

    @DeleteMapping(path={"/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> deleteWorkbasket(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException, WorkbasketInUseException, InvalidArgumentException {
        ResponseEntity result = ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
        this.workbasketService.deleteWorkbasket(workbasketId);
        return result;
    }

    @PostMapping
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketResource> createWorkbasket(@RequestBody WorkbasketResource workbasketResource) throws InvalidWorkbasketException, NotAuthorizedException, WorkbasketAlreadyExistException, WorkbasketNotFoundException, DomainNotFoundException {
        Workbasket workbasket = this.workbasketAssembler.toModel(workbasketResource);
        workbasket = this.workbasketService.createWorkbasket(workbasket);
        return new ResponseEntity((Object)this.workbasketAssembler.toResource(workbasket), HttpStatus.CREATED);
    }

    @PutMapping(path={"/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketResource> updateWorkbasket(@PathVariable(value="workbasketId") String workbasketId, @RequestBody WorkbasketResource workbasketResource) throws InvalidWorkbasketException, WorkbasketNotFoundException, NotAuthorizedException {
        if (!workbasketId.equals(workbasketResource.workbasketId)) {
            throw new InvalidWorkbasketException("Target-WB-ID('" + workbasketId + "') is not identical with the WB-ID of to object which should be updated. ID=('" + workbasketResource.getId() + "')");
        }
        Workbasket workbasket = this.workbasketAssembler.toModel(workbasketResource);
        workbasket = this.workbasketService.updateWorkbasket(workbasket);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.workbasketAssembler.toResource(workbasket)));
        return result;
    }

    @GetMapping(path={"/{workbasketId}/workbasketAccessItems"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<Resources<WorkbasketAccessItemResource>> getWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId) throws NotAuthorizedException, WorkbasketNotFoundException {
        List accessItems = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        Resources<WorkbasketAccessItemResource> accessItemListResource = this.accessItemListAssembler.toResource(workbasketId, accessItems);
        ResponseEntity result = new ResponseEntity(accessItemListResource, HttpStatus.OK);
        return result;
    }

    @PutMapping(value={"/{workbasketId}/workbasketAccessItems"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Resources<WorkbasketAccessItemResource>> setWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId, @RequestBody List<WorkbasketAccessItemResource> workbasketAccessResourceItems) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException {
        if (workbasketAccessResourceItems == null) {
            throw new InvalidArgumentException("Can\u00b4t create something with NULL body-value.");
        }
        ArrayList wbAccessItems = new ArrayList();
        workbasketAccessResourceItems.forEach(item -> wbAccessItems.add(this.workbasketAccessItemAssembler.toModel((WorkbasketAccessItemResource)((Object)item))));
        this.workbasketService.setWorkbasketAccessItems(workbasketId, wbAccessItems);
        List updatedWbAccessItems = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        Resources<WorkbasketAccessItemResource> accessItemListResource = this.accessItemListAssembler.toResource(workbasketId, updatedWbAccessItems);
        return new ResponseEntity(accessItemListResource, HttpStatus.OK);
    }

    @GetMapping(path={"/{workbasketId}/distribution-targets"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<Resources<DistributionTargetResource>> getDistributionTargets(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        List distributionTargets = this.workbasketService.getDistributionTargets(workbasketId);
        Resources<DistributionTargetResource> distributionTargetListResource = this.distributionTargetListAssembler.toResource(workbasketId, distributionTargets);
        ResponseEntity result = new ResponseEntity(distributionTargetListResource, HttpStatus.OK);
        return result;
    }

    @PutMapping(path={"/{workbasketId}/distribution-targets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Resources<DistributionTargetResource>> setDistributionTargetsForWorkbasketId(@PathVariable(value="workbasketId") String sourceWorkbasketId, @RequestBody List<String> targetWorkbasketIds) throws WorkbasketNotFoundException, NotAuthorizedException {
        this.workbasketService.setDistributionTargets(sourceWorkbasketId, targetWorkbasketIds);
        List distributionTargets = this.workbasketService.getDistributionTargets(sourceWorkbasketId);
        Resources<DistributionTargetResource> distributionTargetListResource = this.distributionTargetListAssembler.toResource(sourceWorkbasketId, distributionTargets);
        return new ResponseEntity(distributionTargetListResource, HttpStatus.OK);
    }

    @DeleteMapping(path={"/distribution-targets/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Resources<DistributionTargetResource>> removeDistributionTargetForWorkbasketId(@PathVariable(value="workbasketId") String targetWorkbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        List sourceWorkbaskets = this.workbasketService.getDistributionSources(targetWorkbasketId);
        for (WorkbasketSummary source : sourceWorkbaskets) {
            this.workbasketService.removeDistributionTarget(source.getId(), targetWorkbasketId);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private WorkbasketQuery applySortingParams(WorkbasketQuery query, MultiValueMap<String, String> params) throws IllegalArgumentException {
        String sortBy = (String)params.getFirst((Object)SORT_BY);
        if (sortBy != null) {
            BaseQuery.SortDirection sortDirection = params.getFirst((Object)SORT_DIRECTION) != null && "desc".equals(params.getFirst((Object)SORT_DIRECTION)) ? BaseQuery.SortDirection.DESCENDING : BaseQuery.SortDirection.ASCENDING;
            switch (sortBy) {
                case "name": {
                    query = query.orderByName(sortDirection);
                    break;
                }
                case "key": {
                    query = query.orderByKey(sortDirection);
                    break;
                }
                case "owner": {
                    query = query.orderByOwner(sortDirection);
                    break;
                }
                case "type": {
                    query = query.orderByType(sortDirection);
                    break;
                }
                case "description": {
                    query = query.orderByDescription(sortDirection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown order '" + sortBy + "'");
                }
            }
        }
        params.remove((Object)SORT_BY);
        params.remove((Object)SORT_DIRECTION);
        return query;
    }

    private WorkbasketQuery applyFilterParams(WorkbasketQuery query, MultiValueMap<String, String> params) throws InvalidArgumentException {
        String[] names;
        if (params.containsKey((Object)NAME)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)NAME));
            query.nameIn(names);
            params.remove((Object)NAME);
        }
        if (params.containsKey((Object)NAME_LIKE)) {
            query.nameLike(new String[]{LIKE + (String)((List)params.get((Object)NAME_LIKE)).get(0) + LIKE});
            params.remove((Object)NAME_LIKE);
        }
        if (params.containsKey((Object)KEY)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)KEY));
            query.keyIn(names);
            params.remove((Object)KEY);
        }
        if (params.containsKey((Object)KEY_LIKE)) {
            query.keyLike(new String[]{LIKE + (String)((List)params.get((Object)KEY_LIKE)).get(0) + LIKE});
            params.remove((Object)KEY_LIKE);
        }
        if (params.containsKey((Object)OWNER)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)OWNER));
            query.ownerIn(names);
            params.remove((Object)OWNER);
        }
        if (params.containsKey((Object)OWNER_LIKE)) {
            query.ownerLike(new String[]{LIKE + (String)((List)params.get((Object)OWNER_LIKE)).get(0) + LIKE});
            params.remove((Object)OWNER_LIKE);
        }
        if (params.containsKey((Object)DESCRIPTION_LIKE)) {
            query.descriptionLike(new String[]{LIKE + (String)((List)params.get((Object)DESCRIPTION_LIKE)).get(0) + LIKE});
            params.remove((Object)DESCRIPTION_LIKE);
        }
        if (params.containsKey((Object)DOMAIN)) {
            query.domainIn(this.extractCommaSeparatedFields((List)params.get((Object)DOMAIN)));
            params.remove((Object)DOMAIN);
        }
        if (params.containsKey((Object)TYPE)) {
            switch ((String)params.getFirst((Object)TYPE)) {
                case "PERSONAL": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.PERSONAL});
                    break;
                }
                case "GROUP": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.GROUP});
                    break;
                }
                case "CLEARANCE": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.CLEARANCE});
                    break;
                }
                case "TOPIC": {
                    query.typeIn(new WorkbasketType[]{WorkbasketType.TOPIC});
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Unknown Workbasket type '" + (String)params.getFirst((Object)TYPE) + "'");
                }
            }
            params.remove((Object)TYPE);
        }
        if (params.containsKey((Object)REQUIRED_PERMISSION)) {
            block50: for (String authorization : Arrays.asList(((String)params.getFirst((Object)REQUIRED_PERMISSION)).split(","))) {
                switch (authorization.trim()) {
                    case "READ": {
                        query.callerHasPermission(WorkbasketPermission.READ);
                        continue block50;
                    }
                    case "OPEN": {
                        query.callerHasPermission(WorkbasketPermission.OPEN);
                        continue block50;
                    }
                    case "APPEND": {
                        query.callerHasPermission(WorkbasketPermission.APPEND);
                        continue block50;
                    }
                    case "TRANSFER": {
                        query.callerHasPermission(WorkbasketPermission.TRANSFER);
                        continue block50;
                    }
                    case "DISTRIBUTE": {
                        query.callerHasPermission(WorkbasketPermission.DISTRIBUTE);
                        continue block50;
                    }
                    case "CUSTOM_1": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_1);
                        continue block50;
                    }
                    case "CUSTOM_2": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_2);
                        continue block50;
                    }
                    case "CUSTOM_3": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_3);
                        continue block50;
                    }
                    case "CUSTOM_4": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_4);
                        continue block50;
                    }
                    case "CUSTOM_5": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_5);
                        continue block50;
                    }
                    case "CUSTOM_6": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_6);
                        continue block50;
                    }
                    case "CUSTOM_7": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_7);
                        continue block50;
                    }
                    case "CUSTOM_8": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_8);
                        continue block50;
                    }
                    case "CUSTOM_9": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_9);
                        continue block50;
                    }
                    case "CUSTOM_10": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_10);
                        continue block50;
                    }
                    case "CUSTOM_11": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_11);
                        continue block50;
                    }
                    case "CUSTOM_12": {
                        query.callerHasPermission(WorkbasketPermission.CUSTOM_12);
                        continue block50;
                    }
                }
                throw new InvalidArgumentException("Unknown authorization '" + authorization + "'");
            }
            params.remove((Object)REQUIRED_PERMISSION);
        }
        return query;
    }
}

