/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource.assembler;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import pro.taskana.WorkbasketSummary;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.WorkbasketSummaryResource;
import pro.taskana.rest.resource.assembler.WorkbasketSummaryResourceAssembler;

public class WorkbasketSummaryResourcesAssembler {
    public PagedResources<WorkbasketSummaryResource> toResources(List<WorkbasketSummary> workbasketSummaries, PagedResources.PageMetadata pageMetadata) {
        WorkbasketSummaryResourceAssembler assembler = new WorkbasketSummaryResourceAssembler();
        List resources = assembler.toResources(workbasketSummaries);
        PagedResources pagedResources = new PagedResources((Collection)resources, pageMetadata, new Link[0]);
        UriComponentsBuilder original = this.getBuilderForOriginalUri();
        pagedResources.add(new Link(original.toUriString()).withSelfRel());
        if (pageMetadata != null) {
            pagedResources.add(ControllerLinkBuilder.linkTo(WorkbasketController.class).withRel("allWorkbaskets"));
            pagedResources.add(new Link(original.replaceQueryParam("page", new Object[]{1}).toUriString()).withRel("first"));
            pagedResources.add(new Link(original.replaceQueryParam("page", new Object[]{pageMetadata.getTotalPages()}).toUriString()).withRel("last"));
            if (pageMetadata.getNumber() > 1L) {
                pagedResources.add(new Link(original.replaceQueryParam("page", new Object[]{pageMetadata.getNumber() - 1L}).toUriString()).withRel("prev"));
            }
            if (pageMetadata.getNumber() < pageMetadata.getTotalPages()) {
                pagedResources.add(new Link(original.replaceQueryParam("page", new Object[]{pageMetadata.getNumber() + 1L}).toUriString()).withRel("next"));
            }
        }
        return pagedResources;
    }

    private UriComponentsBuilder getBuilderForOriginalUri() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        UriComponentsBuilder baseUri = ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)request).path(request.getRequestURI());
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            for (String value : (String[])entry.getValue()) {
                baseUri.queryParam((String)entry.getKey(), new Object[]{value});
            }
        }
        UriComponentsBuilder original = baseUri;
        return original;
    }
}

