/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.TaskanaRole;
import pro.taskana.configuration.TaskanaEngineConfiguration;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.rest.resource.TaskanaUserInfoResource;
import pro.taskana.rest.resource.VersionResource;
import pro.taskana.security.CurrentUserContext;

@RestController
public class TaskanaEngineController {
    @Autowired
    TaskanaEngineConfiguration taskanaEngineConfiguration;
    @Autowired
    TaskanaEngineImpl taskanaEngineImpl;

    @GetMapping(path={"/v1/domains"}, produces={"application/json"})
    public ResponseEntity<List<String>> getDomains() {
        return new ResponseEntity((Object)this.taskanaEngineConfiguration.getDomains(), HttpStatus.OK);
    }

    @GetMapping(path={"/v1/classification-categories"}, produces={"application/json"})
    public ResponseEntity<List<String>> getClassificationCategories() {
        return new ResponseEntity((Object)this.taskanaEngineConfiguration.getClassificationCategories(), HttpStatus.OK);
    }

    @GetMapping(path={"/v1/classification-types"}, produces={"application/json"})
    public ResponseEntity<List<String>> getClassificationTypes() {
        return new ResponseEntity((Object)this.taskanaEngineConfiguration.getClassificationTypes(), HttpStatus.OK);
    }

    @GetMapping(path={"/v1/current-user-info"}, produces={"application/json"})
    public ResponseEntity<TaskanaUserInfoResource> getCurrentUserInfo() {
        TaskanaUserInfoResource resource = new TaskanaUserInfoResource();
        resource.setUserId(CurrentUserContext.getUserid());
        resource.setGroupIds(CurrentUserContext.getGroupIds());
        for (TaskanaRole role : this.taskanaEngineConfiguration.getRoleMap().keySet()) {
            if (!this.taskanaEngineImpl.isUserInRole(new TaskanaRole[]{role})) continue;
            resource.getRoles().add(role);
        }
        return new ResponseEntity((Object)resource, HttpStatus.OK);
    }

    @GetMapping(path={"/v1/version"}, produces={"application/json"})
    public ResponseEntity<VersionResource> currentVersion() {
        String version = TaskanaEngineController.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "1.0-DEFAULT";
        }
        VersionResource resource = new VersionResource();
        resource.setVersion(version);
        return new ResponseEntity((Object)resource, HttpStatus.OK);
    }
}

