/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource.assembler;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pro.taskana.Attachment;
import pro.taskana.TaskService;
import pro.taskana.impl.AttachmentImpl;
import pro.taskana.rest.resource.AttachmentResource;
import pro.taskana.rest.resource.assembler.ClassificationSummaryResourceAssembler;

@Component
public class AttachmentResourcesAssembler {
    @Autowired
    private TaskService taskService;
    @Autowired
    private ClassificationSummaryResourceAssembler classificationAssembler;

    public List<AttachmentResource> toResources(List<Attachment> attachments) {
        ArrayList<AttachmentResource> resourceList = new ArrayList<AttachmentResource>();
        for (Attachment a : attachments) {
            AttachmentResource resource = new AttachmentResource();
            BeanUtils.copyProperties((Object)a, (Object)((Object)resource));
            if (a.getCreated() != null) {
                resource.setCreated(a.getCreated().toString());
            }
            if (a.getModified() != null) {
                resource.setModified(a.getModified().toString());
            }
            if (a.getReceived() != null) {
                resource.setReceived(a.getReceived().toString());
            }
            resource.setAttachmentId(a.getId());
            resource.setClassificationSummary(this.classificationAssembler.toResource(a.getClassificationSummary()));
            resourceList.add(resource);
        }
        return resourceList;
    }

    public List<Attachment> toModel(List<AttachmentResource> resources) {
        ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
        for (AttachmentResource ar : resources) {
            AttachmentImpl attachment = (AttachmentImpl)this.taskService.newAttachment();
            BeanUtils.copyProperties((Object)((Object)ar), (Object)attachment);
            attachment.setId(ar.getAttachmentId());
            attachment.setClassificationSummary(this.classificationAssembler.toModel(ar.getClassificationSummary()));
            attachmentList.add((Attachment)attachment);
        }
        return attachmentList;
    }
}

