/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.ldap;

import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.ldap.filter.WhitespaceWildcardsFilter;
import org.springframework.stereotype.Component;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.SystemException;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.rest.resource.AccessIdResource;

@Component
public class LdapClient {
    public static final String TASKANA_USE_LDAP_PROP_NAME = "taskana.ldap.useLdap";
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapClient.class);
    private static final String CN = "cn";
    private boolean active = false;
    @Autowired
    private Environment env;
    @Autowired(required=false)
    private LdapTemplate ldapTemplate;
    private String userSearchBase;
    private String userSearchFilterName;
    private String userSearchFilterValue;
    private String userFirstnameAttribute;
    private String userLastnameAttribute;
    private String userIdAttribute;
    private String groupSearchBase;
    private String groupSearchFilterName;
    private String groupSearchFilterValue;
    private String groupNameAttribute;
    private String groupsOfUser;
    private int minSearchForLength;
    private int maxNumberOfReturnedAccessIds;
    private String message;

    @PostConstruct
    private void init() {
        String strMinSearchForLength = this.getMinSearchForLengthAsString();
        this.minSearchForLength = strMinSearchForLength == null || strMinSearchForLength.isEmpty() ? 3 : Integer.parseInt(strMinSearchForLength);
        String strMaxNumberOfReturnedAccessIds = this.getMaxNumberOfReturnedAccessIdsAsString();
        this.maxNumberOfReturnedAccessIds = strMaxNumberOfReturnedAccessIds == null || strMaxNumberOfReturnedAccessIds.isEmpty() ? 50 : Integer.parseInt(strMaxNumberOfReturnedAccessIds);
        if (this.useLdap()) {
            this.userSearchBase = this.getUserSearchBase();
            this.userSearchFilterName = this.getUserSearchFilterName();
            this.userSearchFilterValue = this.getUserSearchFilterValue();
            this.userFirstnameAttribute = this.getUserFirstnameAttribute();
            this.userLastnameAttribute = this.getUserLastnameAttribute();
            this.userIdAttribute = this.getUserIdAttribute();
            this.groupSearchBase = this.getGroupSearchBase();
            this.groupSearchFilterName = this.getGroupSearchFilterName();
            this.groupSearchFilterValue = this.getGroupSearchFilterValue();
            this.groupNameAttribute = this.getGroupNameAttribute();
            this.groupsOfUser = this.getGroupsOfUser();
            this.ldapTemplate.setDefaultCountLimit(this.maxNumberOfReturnedAccessIds);
            String emptyMessage = "taskana.ldap.useLdap is set to true, but";
            this.message = "taskana.ldap.useLdap is set to true, but";
            if (this.userSearchBase == null) {
                this.message = this.message + " taskana.ldap.userSearchBase is not configured.";
            }
            if (this.userSearchFilterName == null) {
                this.message = this.message + " taskana.ldap.userSearchFilterName is not configured.";
            }
            if (this.userSearchFilterValue == null) {
                this.message = this.message + " taskana.ldap.userSearchFilterValue is not configured.";
            }
            if (this.userFirstnameAttribute == null) {
                this.message = this.message + " taskana.ldap.userFirstnameAttribute is not configured.";
            }
            if (this.userLastnameAttribute == null) {
                this.message = this.message + " taskana.ldap.userLastnameAttribute is not configured.";
            }
            if (this.userIdAttribute == null) {
                this.message = this.message + " taskana.ldap.userIdAttribute is not configured.";
            }
            if (this.groupSearchBase == null) {
                this.message = this.message + " taskana.ldap.groupSearchBase is not configured.";
            }
            if (this.groupSearchFilterName == null) {
                this.message = this.message + " taskana.ldap.groupSearchFilterName is not configured.";
            }
            if (this.groupSearchFilterValue == null) {
                this.message = this.message + " taskana.ldap.groupSearchFilterValue is not configured.";
            }
            if (this.groupNameAttribute == null) {
                this.message = this.message + " taskana.ldap.groupNameAttribute is not configured.";
            }
            if (this.groupsOfUser == null) {
                this.message = this.message + " taskana.ldap.groupsOfUser is not configured.";
            }
            if (!this.message.equals("taskana.ldap.useLdap is set to true, but")) {
                throw new SystemException(this.message);
            }
            this.active = true;
        }
    }

    public List<AccessIdResource> searchUsersAndGroups(String name) throws InvalidArgumentException {
        LOGGER.debug("entry to searchUsersAndGroups(name = {})", (Object)name);
        if (!this.active) {
            throw new SystemException("LdapClient was called but is not active due to missing configuration: " + this.message);
        }
        this.testMinSearchForLength(name);
        List<AccessIdResource> users = this.searchUsersByName(name);
        users.addAll(this.searchGroupsByName(name));
        users.sort((a, b) -> a.getAccessId().compareToIgnoreCase(b.getAccessId()));
        List<AccessIdResource> result = users.subList(0, Math.min(users.size(), this.maxNumberOfReturnedAccessIds));
        LOGGER.debug("exit from searchUsersAndGroups(name = {}). Returning {} users and groups: {}", new Object[]{name, users.size(), LoggerUtils.listToString(result)});
        return result;
    }

    public List<AccessIdResource> searchUsersByName(String name) throws InvalidArgumentException {
        LOGGER.debug("entry to searchUsersByName(name = {}).", (Object)name);
        if (!this.active) {
            throw new SystemException("LdapClient was called but is not active due to missing configuration: " + this.message);
        }
        this.testMinSearchForLength(name);
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getUserSearchFilterName(), this.getUserSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserFirstnameAttribute(), name));
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserLastnameAttribute(), name));
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserIdAttribute(), name));
        andFilter.and((Filter)orFilter);
        String[] userAttributesToReturn = new String[]{this.getUserFirstnameAttribute(), this.getUserLastnameAttribute(), this.getUserIdAttribute()};
        List accessIds = this.ldapTemplate.search(this.getUserSearchBase(), andFilter.encode(), 2, userAttributesToReturn, (ContextMapper)new UserContextMapper());
        LOGGER.debug("exit from searchUsersByName. Retrieved the following users: {}.", (Object)LoggerUtils.listToString((List)accessIds));
        return accessIds;
    }

    public List<AccessIdResource> searchGroupsByName(String name) throws InvalidArgumentException {
        LOGGER.debug("entry to searchGroupsByName(name = {}).", (Object)name);
        if (!this.active) {
            throw new SystemException("LdapClient was called but is not active due to missing configuration: " + this.message);
        }
        this.testMinSearchForLength(name);
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getGroupSearchFilterName(), this.getGroupSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getGroupNameAttribute(), name));
        if (!CN.equals(this.groupNameAttribute)) {
            orFilter.or((Filter)new WhitespaceWildcardsFilter(CN, name));
        }
        andFilter.and((Filter)orFilter);
        String[] groupAttributesToReturn = CN.equals(this.groupNameAttribute) ? new String[]{CN} : new String[]{this.getGroupNameAttribute(), CN};
        List accessIds = this.ldapTemplate.search(this.getGroupSearchBase(), andFilter.encode(), 2, groupAttributesToReturn, (ContextMapper)new GroupContextMapper());
        LOGGER.debug("Exit from searchGroupsByName. Retrieved the following groups: {}", (Object)LoggerUtils.listToString((List)accessIds));
        return accessIds;
    }

    public List<AccessIdResource> searchGroupsofUsersIsMember(String name) throws InvalidArgumentException {
        LOGGER.debug("entry to searchGroupsofUsersIsMember(name = {}).", (Object)name);
        if (!this.active) {
            throw new SystemException("LdapClient was called but is not active due to missing configuration: " + this.message);
        }
        this.testMinSearchForLength(name);
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new WhitespaceWildcardsFilter(this.getGroupNameAttribute(), ""));
        andFilter.and((Filter)new EqualsFilter(this.getGroupsOfUser(), name));
        String[] userAttributesToReturn = new String[]{this.getUserIdAttribute(), this.getGroupNameAttribute()};
        List accessIds = this.ldapTemplate.search(this.getGroupSearchBase(), andFilter.encode(), 2, userAttributesToReturn, (ContextMapper)new GroupContextMapper());
        LOGGER.debug("exit from searchGroupsofUsersIsMember. Retrieved the following users: {}.", (Object)LoggerUtils.listToString((List)accessIds));
        return accessIds;
    }

    private void testMinSearchForLength(String name) throws InvalidArgumentException {
        if (name == null || name.length() < this.minSearchForLength) {
            throw new InvalidArgumentException("searchFor string " + name + " is too short. Minimum Length = " + this.getMinSearchForLength());
        }
    }

    public boolean useLdap() {
        String useLdap = this.env.getProperty(TASKANA_USE_LDAP_PROP_NAME);
        if (useLdap == null || useLdap.isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(useLdap);
    }

    public String getUserSearchBase() {
        return this.env.getProperty("taskana.ldap.userSearchBase");
    }

    public String getUserSearchFilterName() {
        return this.env.getProperty("taskana.ldap.userSearchFilterName");
    }

    public String getUserSearchFilterValue() {
        return this.env.getProperty("taskana.ldap.userSearchFilterValue");
    }

    public String getUserFirstnameAttribute() {
        return this.env.getProperty("taskana.ldap.userFirstnameAttribute");
    }

    public String getUserLastnameAttribute() {
        return this.env.getProperty("taskana.ldap.userLastnameAttribute");
    }

    public String getUserIdAttribute() {
        return this.env.getProperty("taskana.ldap.userIdAttribute");
    }

    public String getGroupSearchBase() {
        return this.env.getProperty("taskana.ldap.groupSearchBase");
    }

    public String getGroupSearchFilterName() {
        return this.env.getProperty("taskana.ldap.groupSearchFilterName");
    }

    public String getGroupSearchFilterValue() {
        return this.env.getProperty("taskana.ldap.groupSearchFilterValue");
    }

    public String getGroupNameAttribute() {
        return this.env.getProperty("taskana.ldap.groupNameAttribute");
    }

    public String getMinSearchForLengthAsString() {
        return this.env.getProperty("taskana.ldap.minSearchForLength");
    }

    public int getMinSearchForLength() {
        return this.minSearchForLength;
    }

    public String getMaxNumberOfReturnedAccessIdsAsString() {
        return this.env.getProperty("taskana.ldap.maxNumberOfReturnedAccessIds");
    }

    public int getMaxNumberOfReturnedAccessIds() {
        return this.maxNumberOfReturnedAccessIds;
    }

    public String getGroupsOfUser() {
        return this.env.getProperty("taskana.ldap.groupsOfUser");
    }

    public boolean isGroup(String accessId) {
        return accessId.contains(this.getGroupSearchBase());
    }

    private class GroupContextMapper
    extends AbstractContextMapper<AccessIdResource> {
        private GroupContextMapper() {
        }

        public AccessIdResource doMapFromContext(DirContextOperations context) {
            AccessIdResource accessId = new AccessIdResource();
            accessId.setAccessId(context.getNameInNamespace());
            accessId.setName(context.getStringAttribute(LdapClient.this.getGroupNameAttribute()));
            return accessId;
        }
    }

    private class UserContextMapper
    extends AbstractContextMapper<AccessIdResource> {
        private UserContextMapper() {
        }

        public AccessIdResource doMapFromContext(DirContextOperations context) {
            AccessIdResource accessId = new AccessIdResource();
            accessId.setAccessId(context.getStringAttribute(LdapClient.this.getUserIdAttribute()));
            String firstName = context.getStringAttribute(LdapClient.this.getUserFirstnameAttribute());
            String lastName = context.getStringAttribute(LdapClient.this.getUserLastnameAttribute());
            accessId.setName(lastName + ", " + firstName);
            return accessId;
        }
    }
}

