/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.ldap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
public class LdapConfiguration {
    @Autowired
    private Environment env;

    @Bean
    public LdapContextSource contextSource() {
        LdapContextSource contextSource = new LdapContextSource();
        String useLdapConfigValue = this.env.getProperty("taskana.ldap.useLdap");
        boolean useLdap = useLdapConfigValue == null || useLdapConfigValue.isEmpty() ? false : Boolean.parseBoolean(useLdapConfigValue);
        if (useLdap) {
            contextSource.setUrl(this.env.getRequiredProperty("taskana.ldap.serverUrl"));
            contextSource.setBase(this.env.getRequiredProperty("taskana.ldap.baseDn"));
            contextSource.setUserDn(this.env.getRequiredProperty("taskana.ldap.bindDn"));
            contextSource.setPassword(this.env.getRequiredProperty("taskana.ldap.bindPassword"));
        } else {
            contextSource.setUrl("ldap://localhost:9999");
            contextSource.setBase("o=taskana");
            contextSource.setUserDn("user");
            contextSource.setPassword("secret");
        }
        return contextSource;
    }

    @Bean(name={"ldapTemplate"})
    @Conditional(value={WithLdapCondition.class})
    public LdapTemplate getActiveLdapTemplate() {
        return new LdapTemplate((ContextSource)this.contextSource());
    }

    public static class WithLdapCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String useLdap = context.getEnvironment().getProperty("taskana.ldap.useLdap");
            if (useLdap == null || useLdap.isEmpty()) {
                return false;
            }
            return Boolean.parseBoolean(useLdap);
        }
    }
}

