/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.BaseQuery;
import pro.taskana.Classification;
import pro.taskana.ClassificationQuery;
import pro.taskana.ClassificationService;
import pro.taskana.exceptions.ClassificationAlreadyExistException;
import pro.taskana.exceptions.ClassificationInUseException;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.ConcurrencyException;
import pro.taskana.exceptions.DomainNotFoundException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.rest.AbstractPagingController;
import pro.taskana.rest.resource.ClassificationResource;
import pro.taskana.rest.resource.ClassificationSummaryResource;
import pro.taskana.rest.resource.assembler.ClassificationResourceAssembler;
import pro.taskana.rest.resource.assembler.ClassificationSummaryResourcesAssembler;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@RequestMapping(path={"/v1/classifications"}, produces={"application/hal+json"})
public class ClassificationController
extends AbstractPagingController {
    private static final String LIKE = "%";
    private static final String NAME = "name";
    private static final String NAME_LIKE = "name-like";
    private static final String KEY = "key";
    private static final String DOMAIN = "domain";
    private static final String CATEGORY = "category";
    private static final String TYPE = "type";
    private static final String CUSTOM_1_LIKE = "custom-1-like";
    private static final String CUSTOM_2_LIKE = "custom-2-like";
    private static final String CUSTOM_3_LIKE = "custom-3-like";
    private static final String CUSTOM_4_LIKE = "custom-4-like";
    private static final String CUSTOM_5_LIKE = "custom-5-like";
    private static final String CUSTOM_6_LIKE = "custom-6-like";
    private static final String CUSTOM_7_LIKE = "custom-7-like";
    private static final String CUSTOM_8_LIKE = "custom-8-like";
    private static final String SORT_BY = "sort-by";
    private static final String SORT_DIRECTION = "order";
    private static final String PAGING_PAGE = "page";
    private static final String PAGING_PAGE_SIZE = "page-size";
    @Autowired
    private ClassificationService classificationService;
    @Autowired
    private ClassificationResourceAssembler classificationResourceAssembler;

    @GetMapping
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<PagedResources<ClassificationSummaryResource>> getClassifications(@RequestParam MultiValueMap<String, String> params) throws InvalidArgumentException {
        ClassificationQuery query = this.classificationService.createClassificationQuery();
        query = this.applySortingParams(query, params);
        query = this.applyFilterParams(query, params);
        PagedResources.PageMetadata pageMetadata = null;
        List classificationSummaries = null;
        String page = (String)params.getFirst((Object)PAGING_PAGE);
        String pageSize = (String)params.getFirst((Object)PAGING_PAGE_SIZE);
        params.remove((Object)PAGING_PAGE);
        params.remove((Object)PAGING_PAGE_SIZE);
        this.validateNoInvalidParameterIsLeft(params);
        if (page != null && pageSize != null) {
            long totalElements = query.count();
            pageMetadata = this.initPageMetadata(pageSize, page, totalElements);
            classificationSummaries = query.listPage((int)pageMetadata.getNumber(), (int)pageMetadata.getSize());
        } else if (page == null && pageSize == null) {
            classificationSummaries = query.list();
        } else {
            throw new InvalidArgumentException("Paging information is incomplete.");
        }
        ClassificationSummaryResourcesAssembler assembler = new ClassificationSummaryResourcesAssembler();
        PagedResources<ClassificationSummaryResource> pagedResources = assembler.toResources(classificationSummaries, pageMetadata);
        return new ResponseEntity(pagedResources, HttpStatus.OK);
    }

    @GetMapping(path={"/{classificationId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ClassificationResource> getClassification(@PathVariable String classificationId) throws ClassificationNotFoundException, NotAuthorizedException, ClassificationAlreadyExistException, ConcurrencyException, DomainNotFoundException, InvalidArgumentException {
        Classification classification = this.classificationService.getClassification(classificationId);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.classificationResourceAssembler.toResource(classification));
    }

    @PostMapping
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<ClassificationResource> createClassification(@RequestBody ClassificationResource resource) throws NotAuthorizedException, ClassificationNotFoundException, ClassificationAlreadyExistException, ConcurrencyException, DomainNotFoundException, InvalidArgumentException {
        Classification classification = this.classificationResourceAssembler.toModel(resource);
        classification = this.classificationService.createClassification(classification);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.classificationResourceAssembler.toResource(classification));
    }

    @PutMapping(path={"/{classificationId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<ClassificationResource> updateClassification(@PathVariable(value="classificationId") String classificationId, @RequestBody ClassificationResource resource) throws NotAuthorizedException, ClassificationNotFoundException, ConcurrencyException, ClassificationAlreadyExistException, DomainNotFoundException, InvalidArgumentException {
        if (!classificationId.equals(resource.classificationId)) {
            throw new InvalidArgumentException("ClassificationId ('" + classificationId + "') of the URI is not identical with the classificationId ('" + resource.getClassificationId() + "') of the object in the payload.");
        }
        Classification classification = this.classificationResourceAssembler.toModel(resource);
        classification = this.classificationService.updateClassification(classification);
        ResponseEntity result = ResponseEntity.ok((Object)((Object)this.classificationResourceAssembler.toResource(classification)));
        return result;
    }

    @DeleteMapping(path={"/{classificationId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<?> deleteClassification(@PathVariable String classificationId) throws ClassificationNotFoundException, ClassificationInUseException, NotAuthorizedException {
        this.classificationService.deleteClassification(classificationId);
        return ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).build();
    }

    private ClassificationQuery applySortingParams(ClassificationQuery query, MultiValueMap<String, String> params) throws IllegalArgumentException {
        String sortBy = (String)params.getFirst((Object)SORT_BY);
        if (sortBy != null) {
            BaseQuery.SortDirection sortDirection = params.getFirst((Object)SORT_DIRECTION) != null && "desc".equals(params.getFirst((Object)SORT_DIRECTION)) ? BaseQuery.SortDirection.DESCENDING : BaseQuery.SortDirection.ASCENDING;
            switch (sortBy) {
                case "category": {
                    query = query.orderByCategory(sortDirection);
                    break;
                }
                case "domain": {
                    query = query.orderByDomain(sortDirection);
                    break;
                }
                case "key": {
                    query = query.orderByKey(sortDirection);
                    break;
                }
                case "name": {
                    query = query.orderByName(sortDirection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown order '" + sortBy + "'");
                }
            }
        }
        params.remove((Object)SORT_BY);
        params.remove((Object)SORT_DIRECTION);
        return query;
    }

    private ClassificationQuery applyFilterParams(ClassificationQuery query, MultiValueMap<String, String> params) throws InvalidArgumentException {
        String[] names;
        if (params.containsKey((Object)NAME)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)NAME));
            query.nameIn(names);
            params.remove((Object)NAME);
        }
        if (params.containsKey((Object)NAME_LIKE)) {
            query.nameLike(new String[]{LIKE + (String)((List)params.get((Object)NAME_LIKE)).get(0) + LIKE});
            params.remove((Object)NAME_LIKE);
        }
        if (params.containsKey((Object)KEY)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)KEY));
            query.keyIn(names);
            params.remove((Object)KEY);
        }
        if (params.containsKey((Object)CATEGORY)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)CATEGORY));
            query.categoryIn(names);
            params.remove((Object)CATEGORY);
        }
        if (params.containsKey((Object)DOMAIN)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)DOMAIN));
            query.domainIn(names);
            params.remove((Object)DOMAIN);
        }
        if (params.containsKey((Object)TYPE)) {
            names = this.extractCommaSeparatedFields((List)params.get((Object)TYPE));
            query.typeIn(names);
            params.remove((Object)TYPE);
        }
        if (params.containsKey((Object)CUSTOM_1_LIKE)) {
            query.customAttributeLike("1", new String[]{LIKE + (String)((List)params.get((Object)CUSTOM_1_LIKE)).get(0) + LIKE});
            params.remove((Object)CUSTOM_1_LIKE);
        }
        if (params.containsKey((Object)CUSTOM_2_LIKE)) {
            query.customAttributeLike("2", new String[]{LIKE + (String)((List)params.get((Object)CUSTOM_2_LIKE)).get(0) + LIKE});
            params.remove((Object)CUSTOM_2_LIKE);
        }
        if (params.containsKey((Object)CUSTOM_3_LIKE)) {
            query.customAttributeLike("3", new String[]{LIKE + (String)((List)params.get((Object)CUSTOM_3_LIKE)).get(0) + LIKE});
            params.remove((Object)CUSTOM_3_LIKE);
        }
        if (params.containsKey((Object)CUSTOM_4_LIKE)) {
            query.customAttributeLike("4", new String[]{LIKE + (String)((List)params.get((Object)CUSTOM_4_LIKE)).get(0) + LIKE});
            params.remove((Object)CUSTOM_4_LIKE);
        }
        if (params.containsKey((Object)CUSTOM_5_LIKE)) {
            query.customAttributeLike("5", new String[]{LIKE + (String)((List)params.get((Object)CUSTOM_5_LIKE)).get(0) + LIKE});
            params.remove((Object)CUSTOM_5_LIKE);
        }
        if (params.containsKey((Object)CUSTOM_6_LIKE)) {
            query.customAttributeLike("6", new String[]{LIKE + (String)((List)params.get((Object)CUSTOM_6_LIKE)).get(0) + LIKE});
            params.remove((Object)CUSTOM_6_LIKE);
        }
        if (params.containsKey((Object)CUSTOM_7_LIKE)) {
            query.customAttributeLike("7", new String[]{LIKE + (String)((List)params.get((Object)CUSTOM_7_LIKE)).get(0) + LIKE});
            params.remove((Object)CUSTOM_7_LIKE);
        }
        if (params.containsKey((Object)CUSTOM_8_LIKE)) {
            query.customAttributeLike("8", new String[]{LIKE + (String)((List)params.get((Object)CUSTOM_8_LIKE)).get(0) + LIKE});
            params.remove((Object)CUSTOM_8_LIKE);
        }
        return query;
    }
}

