/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource.assembler;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketService;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.WorkbasketAccessItemImpl;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.WorkbasketAccessItemResource;
import pro.taskana.rest.resource.assembler.AbstractRessourcesAssembler;
import pro.taskana.rest.resource.assembler.WorkbasketAccessItemsAssembler;

@Component
public class WorkbasketAccessItemAssembler {
    @Autowired
    private WorkbasketService workbasketService;

    public WorkbasketAccessItemResource toResource(WorkbasketAccessItem wbAccItem) throws NotAuthorizedException, WorkbasketNotFoundException {
        WorkbasketAccessItemResource resource = new WorkbasketAccessItemResource();
        BeanUtils.copyProperties((Object)wbAccItem, (Object)((Object)resource));
        resource.setAccessItemId(wbAccItem.getId());
        return this.addLinks(resource, wbAccItem);
    }

    public WorkbasketAccessItem toModel(WorkbasketAccessItemResource wbAccItemRecource) {
        WorkbasketAccessItemImpl wbAccItemModel = (WorkbasketAccessItemImpl)this.workbasketService.newWorkbasketAccessItem(wbAccItemRecource.workbasketId, wbAccItemRecource.accessId);
        BeanUtils.copyProperties((Object)((Object)wbAccItemRecource), (Object)wbAccItemModel);
        wbAccItemModel.setId(wbAccItemRecource.accessItemId);
        return wbAccItemModel;
    }

    private WorkbasketAccessItemResource addLinks(WorkbasketAccessItemResource resource, WorkbasketAccessItem wbAccItem) throws NotAuthorizedException, WorkbasketNotFoundException {
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasket(wbAccItem.getWorkbasketId())).withRel("workbasket"));
        return resource;
    }

    public PagedResources<WorkbasketAccessItemResource> toResources(List<WorkbasketAccessItem> workbasketAccessItems, PagedResources.PageMetadata pageMetadata) {
        WorkbasketAccessItemsAssembler assembler = new WorkbasketAccessItemsAssembler();
        List resources = assembler.toResources(workbasketAccessItems);
        PagedResources pagedResources = new PagedResources((Collection)resources, pageMetadata, new Link[0]);
        UriComponentsBuilder original = AbstractRessourcesAssembler.getBuilderForOriginalUri();
        pagedResources.add(new Link(original.toUriString()).withSelfRel());
        if (pageMetadata != null) {
            pagedResources.add(new Link(original.replaceQueryParam("page", new Object[]{1}).toUriString()).withRel("first"));
            pagedResources.add(new Link(original.replaceQueryParam("page", new Object[]{pageMetadata.getTotalPages()}).toUriString()).withRel("last"));
            if (pageMetadata.getNumber() > 1L) {
                pagedResources.add(new Link(original.replaceQueryParam("page", new Object[]{pageMetadata.getNumber() - 1L}).toUriString()).withRel("prev"));
            }
            if (pageMetadata.getNumber() < pageMetadata.getTotalPages()) {
                pagedResources.add(new Link(original.replaceQueryParam("page", new Object[]{pageMetadata.getNumber() + 1L}).toUriString()).withRel("next"));
            }
        }
        return pagedResources;
    }
}

