/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.ldap.LdapCache;
import pro.taskana.ldap.LdapClient;
import pro.taskana.rest.resource.AccessIdResource;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@RequestMapping(path={"/v1/access-ids"}, produces={"application/hal+json"})
public class AccessIdController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessIdController.class);
    @Autowired
    LdapClient ldapClient;
    private static LdapCache ldapCache;

    @GetMapping
    public ResponseEntity<List<AccessIdResource>> validateAccessIds(@RequestParam(value="search-for") String searchFor) throws InvalidArgumentException {
        LOGGER.debug("Entry to validateAccessIds(search-for= {})", (Object)searchFor);
        if (searchFor.length() < this.ldapClient.getMinSearchForLength()) {
            throw new InvalidArgumentException("searchFor string '" + searchFor + "' is too short. Minimum searchFor length = " + this.ldapClient.getMinSearchForLength());
        }
        if (this.ldapClient.useLdap()) {
            List<AccessIdResource> accessIdUsers = this.ldapClient.searchUsersAndGroups(searchFor);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from validateAccessIds(), returning {}", (Object)new ResponseEntity(accessIdUsers, HttpStatus.OK));
            }
            return new ResponseEntity(accessIdUsers, HttpStatus.OK);
        }
        if (ldapCache != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from validateAccessIds(), returning {}", (Object)new ResponseEntity(ldapCache.findMatchingAccessId(searchFor, this.ldapClient.getMaxNumberOfReturnedAccessIds()), HttpStatus.OK));
            }
            return new ResponseEntity(ldapCache.findMatchingAccessId(searchFor, this.ldapClient.getMaxNumberOfReturnedAccessIds()), HttpStatus.OK);
        }
        LOGGER.debug("Exit from validateAccessIds(), returning {}", (Object)new ResponseEntity(new ArrayList(), HttpStatus.NOT_FOUND));
        return new ResponseEntity(new ArrayList(), HttpStatus.NOT_FOUND);
    }

    @GetMapping(path={"/groups"})
    public ResponseEntity<List<AccessIdResource>> getGroupsByAccessId(@RequestParam(value="access-id") String accessId) throws InvalidArgumentException {
        LOGGER.debug("Entry to getGroupsByAccessId(access-id= {})", (Object)accessId);
        if ((this.ldapClient.useLdap() || ldapCache != null) && !this.validateAccessId(accessId)) {
            throw new InvalidArgumentException("The accessId is invalid");
        }
        if (this.ldapClient.useLdap()) {
            List<AccessIdResource> accessIdUsers = this.ldapClient.searchUsersAndGroups(accessId);
            accessIdUsers.addAll(this.ldapClient.searchGroupsofUsersIsMember(accessId));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from getGroupsByAccessId(), returning {}", (Object)new ResponseEntity(accessIdUsers, HttpStatus.OK));
            }
            return new ResponseEntity(accessIdUsers, HttpStatus.OK);
        }
        if (ldapCache != null) {
            List<AccessIdResource> accessIdUsers = ldapCache.findGroupsOfUser(accessId, this.ldapClient.getMaxNumberOfReturnedAccessIds());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from getGroupsByAccessId(), returning {}", (Object)new ResponseEntity(accessIdUsers, HttpStatus.OK));
            }
            return new ResponseEntity(accessIdUsers, HttpStatus.OK);
        }
        LOGGER.debug("Exit from getGroupsByAccessId(), returning {}", (Object)new ResponseEntity(new ArrayList(), HttpStatus.NOT_FOUND));
        return new ResponseEntity(new ArrayList(), HttpStatus.NOT_FOUND);
    }

    public static void setLdapCache(LdapCache cache) {
        ldapCache = cache;
    }

    private boolean validateAccessId(String accessId) throws InvalidArgumentException {
        return this.ldapClient.useLdap() && this.ldapClient.searchUsersAndGroups(accessId).size() == 1 || !this.ldapClient.useLdap() && ldapCache.validateAccessId(accessId).size() == 1;
    }
}

