/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.TaskanaRole;
import pro.taskana.configuration.TaskanaEngineConfiguration;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.rest.resource.TaskanaUserInfoResource;
import pro.taskana.rest.resource.VersionResource;
import pro.taskana.security.CurrentUserContext;

@RestController
public class TaskanaEngineController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineController.class);
    @Autowired
    TaskanaEngineConfiguration taskanaEngineConfiguration;
    @Autowired
    TaskanaEngineImpl taskanaEngineImpl;
    @Value(value="${version:Local build}")
    private String version;

    @GetMapping(path={"/v1/domains"}, produces={"application/json"})
    public ResponseEntity<List<String>> getDomains() {
        return new ResponseEntity((Object)this.taskanaEngineConfiguration.getDomains(), HttpStatus.OK);
    }

    @GetMapping(path={"/v1/classification-categories"}, produces={"application/json"})
    public ResponseEntity<List<String>> getClassificationCategories(String type) {
        if (type != null) {
            return new ResponseEntity((Object)this.taskanaEngineConfiguration.getClassificationCategoriesByType(type), HttpStatus.OK);
        }
        return new ResponseEntity((Object)this.taskanaEngineConfiguration.getAllClassificationCategories(), HttpStatus.OK);
    }

    @GetMapping(path={"/v1/classification-types"}, produces={"application/json"})
    public ResponseEntity<List<String>> getClassificationTypes() {
        return new ResponseEntity((Object)this.taskanaEngineConfiguration.getClassificationTypes(), HttpStatus.OK);
    }

    @GetMapping(path={"/v1/current-user-info"}, produces={"application/json"})
    public ResponseEntity<TaskanaUserInfoResource> getCurrentUserInfo() {
        LOGGER.debug("Entry to getCurrentUserInfo()");
        TaskanaUserInfoResource resource = new TaskanaUserInfoResource();
        resource.setUserId(CurrentUserContext.getUserid());
        resource.setGroupIds(CurrentUserContext.getGroupIds());
        for (TaskanaRole role : this.taskanaEngineConfiguration.getRoleMap().keySet()) {
            if (!this.taskanaEngineImpl.isUserInRole(new TaskanaRole[]{role})) continue;
            resource.getRoles().add(role);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getCurrentUserInfo(), returning {}", (Object)new ResponseEntity((Object)resource, HttpStatus.OK));
        }
        return new ResponseEntity((Object)resource, HttpStatus.OK);
    }

    @GetMapping(path={"/v1/version"}, produces={"application/json"})
    public ResponseEntity<VersionResource> currentVersion() {
        LOGGER.debug("Entry to currentVersion()");
        VersionResource resource = new VersionResource();
        resource.setVersion(this.version);
        LOGGER.debug("Exit from currentVersion(), returning {}", (Object)new ResponseEntity((Object)resource, HttpStatus.OK));
        return new ResponseEntity((Object)resource, HttpStatus.OK);
    }
}

