/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.DomainNotFoundException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.resource.WorkbasketDefinition;
import pro.taskana.rest.resource.WorkbasketDefinitionAssembler;

@RestController
@RequestMapping(path={"/v1/workbasket-definitions"}, produces={"application/json"})
public class WorkbasketDefinitionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketDefinitionController.class);
    @Autowired
    private WorkbasketService workbasketService;
    @Autowired
    private WorkbasketDefinitionAssembler workbasketDefinitionAssembler;

    @GetMapping
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<WorkbasketSummary>> exportWorkbaskets(@RequestParam(required=false) String domain) {
        List workbasketSummaryList;
        LOGGER.debug("Entry to exportWorkbaskets(domain= {})", (Object)domain);
        WorkbasketQuery workbasketQuery = this.workbasketService.createWorkbasketQuery();
        List list = workbasketSummaryList = domain != null ? workbasketQuery.domainIn(new String[]{domain}).list() : workbasketQuery.list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from exportWorkbaskets(), returning {}", (Object)new ResponseEntity((Object)workbasketSummaryList, HttpStatus.OK));
        }
        return new ResponseEntity((Object)workbasketSummaryList, HttpStatus.OK);
    }

    @PostMapping
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<String> importWorkbaskets(@RequestParam(value="file") MultipartFile file) throws IOException, NotAuthorizedException, DomainNotFoundException, InvalidWorkbasketException, WorkbasketAlreadyExistException, WorkbasketNotFoundException, InvalidArgumentException {
        LOGGER.debug("Entry to importWorkbaskets()");
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List definitions = (List)mapper.readValue(file.getInputStream(), (TypeReference)new TypeReference<List<WorkbasketDefinition>>(){});
        Map<String, String> systemIds = this.workbasketService.createWorkbasketQuery().list().stream().collect(Collectors.toMap(this::logicalId, WorkbasketSummary::getId));
        HashMap<String, String> idConversion = new HashMap<String, String>();
        for (WorkbasketDefinition definition : definitions) {
            Workbasket importedWb = this.workbasketDefinitionAssembler.toModel(definition.workbasket);
            Workbasket workbasket = systemIds.containsKey(this.logicalId(importedWb)) ? this.workbasketService.updateWorkbasket(importedWb) : this.workbasketService.createWorkbasket(importedWb);
            for (WorkbasketAccessItem accessItem : this.workbasketService.getWorkbasketAccessItems(workbasket.getId())) {
                this.workbasketService.deleteWorkbasketAccessItem(accessItem.getId());
            }
            for (WorkbasketAccessItem authorization : definition.authorizations) {
                this.workbasketService.createWorkbasketAccessItem(authorization);
            }
            idConversion.put(importedWb.getId(), workbasket.getId());
        }
        for (WorkbasketDefinition definition : definitions) {
            ArrayList distributionTargets = new ArrayList();
            for (String oldId : definition.distributionTargets) {
                if (idConversion.containsKey(oldId)) {
                    distributionTargets.add(idConversion.get(oldId));
                    continue;
                }
                throw new InvalidWorkbasketException(String.format("invalid import state: Workbasket '%s' does not exist in the given import list", oldId));
            }
            this.workbasketService.setDistributionTargets((String)idConversion.get(definition.workbasket.getWorkbasketId()), distributionTargets);
        }
        LOGGER.debug("Exit from importWorkbaskets(), returning {}", (Object)new ResponseEntity(HttpStatus.OK));
        return new ResponseEntity(HttpStatus.OK);
    }

    private String logicalId(WorkbasketSummary workbasket) {
        return this.logicalId(workbasket.getKey(), workbasket.getDomain());
    }

    private String logicalId(Workbasket workbasket) {
        return this.logicalId(workbasket.getKey(), workbasket.getDomain());
    }

    private String logicalId(String key, String domain) {
        return key + "|" + domain;
    }
}

