/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaRole;
import pro.taskana.configuration.TaskanaEngineConfiguration;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.rest.resource.TaskanaUserInfoResource;
import pro.taskana.rest.resource.VersionResource;
import pro.taskana.security.CurrentUserContext;

@RestController
public class TaskanaEngineController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineController.class);
    TaskanaEngineConfiguration taskanaEngineConfiguration;
    TaskanaEngine taskanaEngine;

    TaskanaEngineController(TaskanaEngineConfiguration taskanaEngineConfiguration, TaskanaEngine taskanaEngine) {
        this.taskanaEngineConfiguration = taskanaEngineConfiguration;
        this.taskanaEngine = taskanaEngine;
    }

    @GetMapping(path={"/v1/domains"}, produces={"application/json"})
    public ResponseEntity<List<String>> getDomains() {
        ResponseEntity response = new ResponseEntity((Object)this.taskanaEngineConfiguration.getDomains(), HttpStatus.OK);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getDomains(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/v1/classification-categories"}, produces={"application/json"})
    public ResponseEntity<List<String>> getClassificationCategories(String type) {
        LOGGER.debug("Entry to getClassificationCategories(type = {})", (Object)type);
        if (type != null) {
            ResponseEntity response = new ResponseEntity((Object)this.taskanaEngineConfiguration.getClassificationCategoriesByType(type), HttpStatus.OK);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from getClassificationCategories(), returning {}", (Object)response);
            }
            return response;
        }
        ResponseEntity response = new ResponseEntity((Object)this.taskanaEngineConfiguration.getAllClassificationCategories(), HttpStatus.OK);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getClassificationCategories(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/v1/classification-types"}, produces={"application/json"})
    public ResponseEntity<List<String>> getClassificationTypes() {
        ResponseEntity response = new ResponseEntity((Object)this.taskanaEngineConfiguration.getClassificationTypes(), HttpStatus.OK);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getClassificationTypes(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/v1/current-user-info"}, produces={"application/json"})
    public ResponseEntity<TaskanaUserInfoResource> getCurrentUserInfo() {
        LOGGER.debug("Entry to getCurrentUserInfo()");
        TaskanaUserInfoResource resource = new TaskanaUserInfoResource();
        resource.setUserId(CurrentUserContext.getUserid());
        resource.setGroupIds(CurrentUserContext.getGroupIds());
        for (TaskanaRole role : this.taskanaEngineConfiguration.getRoleMap().keySet()) {
            if (!this.taskanaEngine.isUserInRole(new TaskanaRole[]{role})) continue;
            resource.getRoles().add(role);
        }
        ResponseEntity response = new ResponseEntity((Object)resource, HttpStatus.OK);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getCurrentUserInfo(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/v1/history-provider-enabled"}, produces={"application/json"})
    public ResponseEntity<Boolean> getIsHistoryProviderEnabled() {
        ResponseEntity response = new ResponseEntity((Object)((TaskanaEngineImpl)this.taskanaEngine).getHistoryEventProducer().isEnabled(), HttpStatus.OK);
        LOGGER.debug("Exit from getIsHistoryProviderEnabled(), returning {}", (Object)response);
        return response;
    }

    @GetMapping(path={"/v1/version"}, produces={"application/json"})
    public ResponseEntity<VersionResource> currentVersion() {
        LOGGER.debug("Entry to currentVersion()");
        VersionResource resource = new VersionResource();
        resource.setVersion(TaskanaEngineConfiguration.class.getPackage().getImplementationVersion());
        ResponseEntity response = new ResponseEntity((Object)resource, HttpStatus.OK);
        LOGGER.debug("Exit from currentVersion(), returning {}", (Object)response);
        return response;
    }
}

