/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.BaseQuery;
import pro.taskana.WorkbasketAccessItemQuery;
import pro.taskana.WorkbasketService;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.ldap.LdapClient;
import pro.taskana.rest.AbstractPagingController;
import pro.taskana.rest.resource.WorkbasketAccessItemAssembler;
import pro.taskana.rest.resource.WorkbasketAccessItemResource;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@RequestMapping(path={"/v1/workbasket-access-items"}, produces={"application/hal+json"})
public class WorkbasketAccessItemController
extends AbstractPagingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketAccessItemController.class);
    private static final String LIKE = "%";
    private static final String WORKBASKET_KEY = "workbasket-key";
    private static final String WORKBASKET_KEY_LIKE = "workbasket-key-like";
    private static final String ACCESS_ID = "access-id";
    private static final String ACCESS_ID_LIKE = "access-id-like";
    private static final String ACCESS_IDS = "access-ids";
    private static final String SORT_BY = "sort-by";
    private static final String SORT_DIRECTION = "order";
    private static final String PAGING_PAGE = "page";
    private static final String PAGING_PAGE_SIZE = "page-size";
    @Autowired
    LdapClient ldapClient;
    @Autowired
    private WorkbasketService workbasketService;

    @GetMapping
    public ResponseEntity<PagedResources<WorkbasketAccessItemResource>> getWorkbasketAccessItems(@RequestParam MultiValueMap<String, String> params) throws NotAuthorizedException, InvalidArgumentException {
        List workbasketAccessItems;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getWorkbasketAccessItems(params= {})", params);
        }
        WorkbasketAccessItemQuery query = this.workbasketService.createWorkbasketAccessItemQuery();
        query = this.getAccessIds(query, params);
        query = this.applyFilterParams(query, params);
        query = this.applySortingParams(query, params);
        PagedResources.PageMetadata pageMetadata = null;
        String page = (String)params.getFirst((Object)PAGING_PAGE);
        String pageSize = (String)params.getFirst((Object)PAGING_PAGE_SIZE);
        params.remove((Object)PAGING_PAGE);
        params.remove((Object)PAGING_PAGE_SIZE);
        this.validateNoInvalidParameterIsLeft(params);
        if (page != null && pageSize != null) {
            long totalElements = query.count();
            pageMetadata = this.initPageMetadata(pageSize, page, totalElements);
            workbasketAccessItems = query.listPage((int)pageMetadata.getNumber(), (int)pageMetadata.getSize());
        } else if (page == null && pageSize == null) {
            workbasketAccessItems = query.list();
        } else {
            throw new InvalidArgumentException("Paging information is incomplete.");
        }
        WorkbasketAccessItemAssembler assembler = new WorkbasketAccessItemAssembler();
        PagedResources<WorkbasketAccessItemResource> pagedResources = assembler.toResources(workbasketAccessItems, pageMetadata);
        ResponseEntity response = new ResponseEntity(pagedResources, HttpStatus.OK);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getWorkbasketAccessItems(), returning {}", (Object)response);
        }
        return response;
    }

    @DeleteMapping
    public ResponseEntity<Void> removeWorkbasketAccessItems(@RequestParam(value="access-id") String accessId) throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("Entry to removeWorkbasketAccessItems(access-id= {})", (Object)accessId);
        if (!this.ldapClient.isGroup(accessId)) {
            List workbasketAccessItemList = this.workbasketService.createWorkbasketAccessItemQuery().accessIdIn(new String[]{accessId}).list();
            if (workbasketAccessItemList != null && !workbasketAccessItemList.isEmpty()) {
                this.workbasketService.deleteWorkbasketAccessItemsForAccessId(accessId);
            }
        } else {
            throw new InvalidArgumentException(accessId + " corresponding to a group, not a user. You just can remove access items for a user");
        }
        ResponseEntity response = new ResponseEntity(HttpStatus.NO_CONTENT);
        LOGGER.debug("Exit from removeWorkbasketAccessItems(), returning {}", (Object)response);
        return response;
    }

    private WorkbasketAccessItemQuery getAccessIds(WorkbasketAccessItemQuery query, MultiValueMap<String, String> params) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getAccessIds(query= {}, params= {})", params);
        }
        if (params.containsKey((Object)ACCESS_IDS)) {
            String[] accessIds = this.extractVerticalBarSeparatedFields((List)params.get((Object)ACCESS_IDS));
            query.accessIdIn(accessIds);
            params.remove((Object)ACCESS_IDS);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getAccessIds(), returning {}", (Object)query);
        }
        return query;
    }

    private WorkbasketAccessItemQuery applyFilterParams(WorkbasketAccessItemQuery query, MultiValueMap<String, String> params) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applyFilterParams(query= {}, params= {})", params);
        }
        if (params.containsKey((Object)WORKBASKET_KEY)) {
            String[] keys = this.extractCommaSeparatedFields((List)params.get((Object)WORKBASKET_KEY));
            query.workbasketKeyIn(keys);
            params.remove((Object)WORKBASKET_KEY);
        }
        if (params.containsKey((Object)WORKBASKET_KEY_LIKE)) {
            query.workbasketKeyLike(new String[]{LIKE + (String)((List)params.get((Object)WORKBASKET_KEY_LIKE)).get(0) + LIKE});
            params.remove((Object)WORKBASKET_KEY_LIKE);
        }
        if (params.containsKey((Object)ACCESS_ID)) {
            String[] accessId = this.extractCommaSeparatedFields((List)params.get((Object)ACCESS_ID));
            query.accessIdIn(accessId);
            params.remove((Object)ACCESS_ID);
        }
        if (params.containsKey((Object)ACCESS_ID_LIKE)) {
            query.accessIdLike(new String[]{LIKE + (String)((List)params.get((Object)ACCESS_ID_LIKE)).get(0) + LIKE});
            params.remove((Object)ACCESS_ID_LIKE);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applyFilterParams(), returning {}", (Object)query);
        }
        return query;
    }

    private WorkbasketAccessItemQuery applySortingParams(WorkbasketAccessItemQuery query, MultiValueMap<String, String> params) throws IllegalArgumentException {
        String sortBy;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to applySortingParams(query= {}, params= {})", params);
        }
        if ((sortBy = (String)params.getFirst((Object)SORT_BY)) != null) {
            BaseQuery.SortDirection sortDirection = params.getFirst((Object)SORT_DIRECTION) != null && "desc".equals(params.getFirst((Object)SORT_DIRECTION)) ? BaseQuery.SortDirection.DESCENDING : BaseQuery.SortDirection.ASCENDING;
            switch (sortBy) {
                case "workbasket-key": {
                    query = query.orderByWorkbasketKey(sortDirection);
                    break;
                }
                case "access-id": {
                    query = query.orderByAccessId(sortDirection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown order '" + sortBy + "'");
                }
            }
        }
        params.remove((Object)SORT_BY);
        params.remove((Object)SORT_DIRECTION);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from applySortingParams(), returning {}", (Object)query);
        }
        return query;
    }

    private String[] extractVerticalBarSeparatedFields(List<String> searchFor) {
        ArrayList values = new ArrayList();
        if (searchFor != null) {
            searchFor.forEach(item -> Collections.addAll(values, item.split("\\|")));
        }
        return values.toArray(new String[0]);
    }
}

