/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;
import pro.taskana.ClassificationService;
import pro.taskana.ClassificationSummary;
import pro.taskana.impl.ClassificationImpl;
import pro.taskana.rest.ClassificationController;
import pro.taskana.rest.resource.ClassificationSummaryResource;

@Component
public class ClassificationSummaryResourceAssembler
extends ResourceAssemblerSupport<ClassificationSummary, ClassificationSummaryResource> {
    @Autowired
    private ClassificationService classificationService;

    public ClassificationSummaryResourceAssembler() {
        super(ClassificationController.class, ClassificationSummaryResource.class);
    }

    public ClassificationSummaryResource toResource(ClassificationSummary classificationSummary) {
        ClassificationSummaryResource resource = (ClassificationSummaryResource)this.createResourceWithId(classificationSummary.getId(), classificationSummary);
        BeanUtils.copyProperties((Object)classificationSummary, (Object)((Object)resource));
        resource.setClassificationId(classificationSummary.getId());
        return resource;
    }

    public ClassificationSummary toModel(ClassificationSummaryResource resource) {
        ClassificationImpl classification = (ClassificationImpl)this.classificationService.newClassification(resource.getKey(), resource.getDomain(), resource.getType());
        classification.setId(resource.getClassificationId());
        BeanUtils.copyProperties((Object)((Object)resource), (Object)classification);
        return classification.asSummary();
    }
}

