/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;
import pro.taskana.TaskState;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.report.row.FoldableRow;
import pro.taskana.impl.report.row.SingleRow;
import pro.taskana.impl.report.structure.ColumnHeader;
import pro.taskana.impl.report.structure.QueryItem;
import pro.taskana.impl.report.structure.Report;
import pro.taskana.impl.report.structure.Row;
import pro.taskana.report.ClassificationReport;
import pro.taskana.report.TaskStatusReport;
import pro.taskana.report.TimestampReport;
import pro.taskana.report.WorkbasketReport;
import pro.taskana.rest.MonitorController;
import pro.taskana.rest.resource.ReportResource;

@Component
public class ReportAssembler {
    public ReportResource toResource(TaskStatusReport report, List<String> domains, List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        ReportResource resource = this.toReportResource((Report)report);
        resource.add(ControllerLinkBuilder.linkTo(((MonitorController)ControllerLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getTasksStatusReport(domains, states)).withSelfRel().expand(new Object[0]));
        return resource;
    }

    public ReportResource toResource(ClassificationReport report) throws NotAuthorizedException, InvalidArgumentException {
        ReportResource resource = this.toReportResource((Report)report);
        resource.add(ControllerLinkBuilder.linkTo(((MonitorController)ControllerLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getTasksClassificationReport()).withSelfRel().expand(new Object[0]));
        return resource;
    }

    public ReportResource toResource(WorkbasketReport report, int daysInPast, List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        ReportResource resource = this.toReportResource((Report)report);
        resource.add(ControllerLinkBuilder.linkTo(((MonitorController)ControllerLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getTasksWorkbasketReport(daysInPast, states)).withSelfRel().expand(new Object[0]));
        return resource;
    }

    public ReportResource toResource(TimestampReport report) throws NotAuthorizedException, InvalidArgumentException {
        ReportResource resource = this.toReportResource((Report)report);
        resource.add(ControllerLinkBuilder.linkTo(((MonitorController)ControllerLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).getDailyEntryExitReport()).withSelfRel().expand(new Object[0]));
        return resource;
    }

    <I extends QueryItem, H extends ColumnHeader<? super I>> ReportResource toReportResource(Report<I, H> report) {
        return this.toReportResource(report, Instant.now());
    }

    <I extends QueryItem, H extends ColumnHeader<? super I>> ReportResource toReportResource(Report<I, H> report, Instant time) {
        String[] header = (String[])report.getColumnHeaders().stream().map(ColumnHeader::getDisplayName).toArray(String[]::new);
        ReportResource.MetaInformation meta = new ReportResource.MetaInformation(report.getClass().getSimpleName(), time.toString(), header, report.getRowDesc());
        List<ReportResource.RowResource> rows = report.getRows().entrySet().stream().sorted(Comparator.comparing(e -> ((String)e.getKey()).toLowerCase())).map(i -> this.transformRow((Row)i.getValue(), (String)i.getKey(), new String[report.getRowDesc().length], 0)).flatMap(Collection::stream).collect(Collectors.toList());
        List<ReportResource.RowResource> sumRow = this.transformRow(report.getSumRow(), meta.getTotalDesc(), new String[report.getRowDesc().length], 0);
        return new ReportResource(meta, rows, sumRow);
    }

    private <I extends QueryItem> List<ReportResource.RowResource> transformRow(Row<I> row, String currentDesc, String[] desc, int depth) {
        if (row.getClass() == SingleRow.class) {
            return Collections.singletonList(this.transformSingleRow((SingleRow)row, currentDesc, desc, depth));
        }
        return this.transformFoldableRow((FoldableRow)row, currentDesc, desc, depth);
    }

    private <I extends QueryItem> ReportResource.RowResource transformSingleRow(SingleRow<I> row, String currentDesc, String[] previousRowDesc, int depth) {
        String[] rowDesc = new String[previousRowDesc.length];
        System.arraycopy(previousRowDesc, 0, rowDesc, 0, depth);
        rowDesc[depth] = currentDesc;
        return new ReportResource.RowResource(row.getCells(), row.getTotalValue(), depth, rowDesc, depth == 0);
    }

    private <I extends QueryItem> List<ReportResource.RowResource> transformFoldableRow(FoldableRow<I> row, String currentDesc, String[] previousRowDesc, int depth) {
        ReportResource.RowResource baseRow = this.transformSingleRow((SingleRow<I>)row, currentDesc, previousRowDesc, depth);
        LinkedList<ReportResource.RowResource> rowList = new LinkedList<ReportResource.RowResource>();
        rowList.add(baseRow);
        row.getFoldableRowKeySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).map(s -> this.transformRow((Row)row.getFoldableRow(s), (String)s, baseRow.getDesc(), depth + 1)).flatMap(Collection::stream).forEachOrdered(rowList::add);
        return rowList;
    }
}

