/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.util.Collection;
import java.util.List;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import pro.taskana.WorkbasketSummary;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.AbstractRessourcesAssembler;
import pro.taskana.rest.resource.WorkbasketSummaryResource;
import pro.taskana.rest.resource.WorkbasketSummaryResourceAssembler;

public class WorkbasketSummaryResourcesAssembler {
    public PagedResources<WorkbasketSummaryResource> toResources(List<WorkbasketSummary> workbasketSummaries, PagedResources.PageMetadata pageMetadata) {
        WorkbasketSummaryResourceAssembler assembler = new WorkbasketSummaryResourceAssembler();
        List resources = assembler.toResources(workbasketSummaries);
        PagedResources pagedResources = new PagedResources((Collection)resources, pageMetadata, new Link[0]);
        UriComponentsBuilder original = AbstractRessourcesAssembler.getBuilderForOriginalUri();
        pagedResources.add(new Link(original.toUriString()).withSelfRel());
        if (pageMetadata != null) {
            pagedResources.add(ControllerLinkBuilder.linkTo(WorkbasketController.class).withRel("allWorkbaskets"));
            pagedResources.add(new Link(original.replaceQueryParam("page", new Object[]{1}).toUriString()).withRel("first"));
            pagedResources.add(new Link(original.replaceQueryParam("page", new Object[]{pageMetadata.getTotalPages()}).toUriString()).withRel("last"));
            if (pageMetadata.getNumber() > 1L) {
                pagedResources.add(new Link(original.replaceQueryParam("page", new Object[]{pageMetadata.getNumber() - 1L}).toUriString()).withRel("prev"));
            }
            if (pageMetadata.getNumber() < pageMetadata.getTotalPages()) {
                pagedResources.add(new Link(original.replaceQueryParam("page", new Object[]{pageMetadata.getNumber() + 1L}).toUriString()).withRel("next"));
            }
        }
        return pagedResources;
    }
}

