/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.TaskMonitorService;
import pro.taskana.TaskState;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.report.header.TimeIntervalColumnHeader;
import pro.taskana.report.ClassificationReport;
import pro.taskana.report.TimestampReport;
import pro.taskana.report.WorkbasketReport;
import pro.taskana.rest.resource.ReportResource;
import pro.taskana.rest.resource.ReportResourceAssembler;

@RestController
@RequestMapping(path={"/v1/monitor"}, produces={"application/hal+json"})
public class MonitorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorController.class);
    private TaskMonitorService taskMonitorService;
    private ReportResourceAssembler reportResourceAssembler;

    MonitorController(TaskMonitorService taskMonitorService, ReportResourceAssembler reportResourceAssembler) {
        this.taskMonitorService = taskMonitorService;
        this.reportResourceAssembler = reportResourceAssembler;
    }

    @GetMapping(path={"/tasks-status-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportResource> getTasksStatusReport(@RequestParam(required=false) List<String> domains, @RequestParam(required=false) List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("Entry to getTasksStatusReport()");
        ResponseEntity response = new ResponseEntity((Object)this.reportResourceAssembler.toResource(this.taskMonitorService.createTaskStatusReportBuilder().stateIn(states).domainIn(domains).buildReport(), domains, states), HttpStatus.OK);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTasksStatusReport(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/tasks-workbasket-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<?> getTasksWorkbasketReport(@RequestParam(value="states") List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("Entry to getTasksWorkbasketReport()");
        ReportResource report = this.reportResourceAssembler.toResource(((WorkbasketReport.Builder)this.taskMonitorService.createWorkbasketReportBuilder().withColumnHeaders(this.getRangeTimeInterval())).buildReport(), states);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTasksWorkbasketReport(), returning {}", (Object)report);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)report);
    }

    @GetMapping(path={"/tasks-workbasket-planned-date-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<?> getTasksWorkbasketPlannedDateReport(@RequestParam(value="daysInPast") int daysInPast, @RequestParam(value="states") List<TaskState> states) throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("Entry to getTasksWorkbasketPlannedDateReport()");
        ReportResource report = this.reportResourceAssembler.toResource(((WorkbasketReport.Builder)((WorkbasketReport.Builder)this.taskMonitorService.createWorkbasketReportBuilder().stateIn(states)).withColumnHeaders(this.getDateTimeInterval(daysInPast))).buildPlannedDateBasedReport(), daysInPast, states);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTasksWorkbasketPlannedDateReport(), returning {}", (Object)report);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)report);
    }

    @GetMapping(path={"/tasks-classification-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportResource> getTasksClassificationReport() throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("Entry to getTasksClassificationReport()");
        ReportResource report = this.reportResourceAssembler.toResource(((ClassificationReport.Builder)this.taskMonitorService.createClassificationReportBuilder().withColumnHeaders(this.getRangeTimeInterval())).buildReport());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTasksClassificationReport(), returning {}", (Object)report);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)report);
    }

    @GetMapping(path={"/timestamp-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportResource> getDailyEntryExitReport() throws NotAuthorizedException, InvalidArgumentException {
        List columnHeaders = IntStream.range(-14, 0).mapToObj(TimeIntervalColumnHeader.Date::new).collect(Collectors.toList());
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.reportResourceAssembler.toResource(((TimestampReport.Builder)this.taskMonitorService.createTimestampReportBuilder().withColumnHeaders(columnHeaders)).buildReport()));
    }

    private List<TimeIntervalColumnHeader> getRangeTimeInterval() {
        return Stream.concat(Stream.concat(Stream.of(new TimeIntervalColumnHeader.Range(Integer.MIN_VALUE, -10), new TimeIntervalColumnHeader.Range(-10, -5)), Stream.of(-4, -3, -2, -1, 0, 1, 2, 3, 4).map(TimeIntervalColumnHeader.Range::new)), Stream.of(new TimeIntervalColumnHeader.Range(5, 10), new TimeIntervalColumnHeader.Range(10, Integer.MAX_VALUE))).collect(Collectors.toList());
    }

    private List<TimeIntervalColumnHeader> getDateTimeInterval(int daysInPast) {
        ArrayList<TimeIntervalColumnHeader> columnHeaders = new ArrayList<TimeIntervalColumnHeader>();
        for (int i = 0; i <= daysInPast; ++i) {
            columnHeaders.add((TimeIntervalColumnHeader)new TimeIntervalColumnHeader.Date(i - daysInPast));
        }
        return columnHeaders;
    }
}

