/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.util.List;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.DistributionTargetResource;

@Component
public class DistributionTargetResourceAssembler
extends ResourceAssemblerSupport<WorkbasketSummary, DistributionTargetResource> {
    public DistributionTargetResourceAssembler() {
        super(WorkbasketController.class, DistributionTargetResource.class);
    }

    public DistributionTargetResource toResource(WorkbasketSummary summary) {
        return new DistributionTargetResource(summary);
    }

    public Resources<DistributionTargetResource> toResources(String workbasketId, List<WorkbasketSummary> distributionTargets) throws WorkbasketNotFoundException, NotAuthorizedException {
        Resources distributionTargetListResource = new Resources((Iterable)super.toResources(distributionTargets), new Link[0]);
        distributionTargetListResource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getDistributionTargets(workbasketId)).withSelfRel());
        distributionTargetListResource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasket(workbasketId)).withRel("workbasket"));
        return distributionTargetListResource;
    }
}

