/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource.links;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriComponentsBuilder;
import pro.taskana.rest.resource.links.PageLinks;

@Configuration
@Aspect
public class PageLinksAspect {
    @Around(value="@annotation(pro.taskana.rest.resource.links.PageLinks) && args(data, page, ..)")
    public ResourceSupport addLinksToPageResource(ProceedingJoinPoint joinPoint, List<?> data, PagedResources.PageMetadata page) throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        PageLinks pageLinks = method.getAnnotation(PageLinks.class);
        Class<?> controller = pageLinks.value();
        UriComponentsBuilder original = this.originalUri(controller, request);
        ResourceSupport resourceSupport = (ResourceSupport)joinPoint.proceed();
        resourceSupport.add(new Link(original.toUriString()).withSelfRel());
        if (page != null) {
            resourceSupport.add(new Link(original.replaceQueryParam("page", new Object[]{1}).toUriString()).withRel("first"));
            resourceSupport.add(new Link(original.replaceQueryParam("page", new Object[]{page.getTotalPages()}).toUriString()).withRel("last"));
            if (page.getNumber() > 1L) {
                resourceSupport.add(new Link(original.replaceQueryParam("page", new Object[]{page.getNumber() - 1L}).toUriString()).withRel("prev"));
            }
            if (page.getNumber() < page.getTotalPages()) {
                resourceSupport.add(new Link(original.replaceQueryParam("page", new Object[]{page.getNumber() + 1L}).toUriString()).withRel("next"));
            }
        }
        return resourceSupport;
    }

    private UriComponentsBuilder originalUri(Class<?> controller, HttpServletRequest request) {
        UriComponentsBuilder baseUri = ControllerLinkBuilder.linkTo(controller).toUriComponentsBuilder();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            for (String value : (String[])entry.getValue()) {
                baseUri.queryParam((String)entry.getKey(), new Object[]{value});
            }
        }
        return baseUri;
    }
}

