/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.ldap.LdapCache;
import pro.taskana.ldap.LdapClient;
import pro.taskana.rest.resource.AccessIdResource;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
@RequestMapping(path={"/api/v1/access-ids"}, produces={"application/hal+json"})
public class AccessIdController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessIdController.class);
    @Autowired
    LdapClient ldapClient;
    private static LdapCache ldapCache;

    @GetMapping
    public ResponseEntity<List<AccessIdResource>> validateAccessIds(@RequestParam(value="search-for") String searchFor) throws InvalidArgumentException {
        LOGGER.debug("Entry to validateAccessIds(search-for= {})", (Object)searchFor);
        if (searchFor.length() < this.ldapClient.getMinSearchForLength()) {
            throw new InvalidArgumentException("searchFor string '" + searchFor + "' is too short. Minimum searchFor length = " + this.ldapClient.getMinSearchForLength());
        }
        if (this.ldapClient.useLdap()) {
            List<AccessIdResource> accessIdUsers = this.ldapClient.searchUsersAndGroups(searchFor);
            ResponseEntity response = ResponseEntity.ok(accessIdUsers);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from validateAccessIds(), returning {}", (Object)response);
            }
            return response;
        }
        if (ldapCache != null) {
            ResponseEntity response = ResponseEntity.ok(ldapCache.findMatchingAccessId(searchFor, this.ldapClient.getMaxNumberOfReturnedAccessIds()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from validateAccessIds(), returning {}", (Object)response);
            }
            return response;
        }
        ResponseEntity response = ResponseEntity.notFound().build();
        LOGGER.debug("Exit from validateAccessIds(), returning {}", (Object)response);
        return response;
    }

    @GetMapping(path={"/groups"})
    public ResponseEntity<List<AccessIdResource>> getGroupsByAccessId(@RequestParam(value="access-id") String accessId) throws InvalidArgumentException {
        LOGGER.debug("Entry to getGroupsByAccessId(access-id= {})", (Object)accessId);
        if ((this.ldapClient.useLdap() || ldapCache != null) && !this.validateAccessId(accessId)) {
            throw new InvalidArgumentException("The accessId is invalid");
        }
        if (this.ldapClient.useLdap()) {
            List<AccessIdResource> accessIdUsers = this.ldapClient.searchUsersAndGroups(accessId);
            accessIdUsers.addAll(this.ldapClient.searchGroupsofUsersIsMember(accessId));
            ResponseEntity response = ResponseEntity.ok(accessIdUsers);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from getGroupsByAccessId(), returning {}", (Object)response);
            }
            return response;
        }
        if (ldapCache != null) {
            List<AccessIdResource> accessIdUsers = ldapCache.findGroupsOfUser(accessId, this.ldapClient.getMaxNumberOfReturnedAccessIds());
            ResponseEntity response = ResponseEntity.ok(accessIdUsers);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from getGroupsByAccessId(), returning {}", (Object)response);
            }
            return response;
        }
        ResponseEntity response = ResponseEntity.notFound().build();
        LOGGER.debug("Exit from getGroupsByAccessId(), returning {}", (Object)response);
        return response;
    }

    public static void setLdapCache(LdapCache cache) {
        ldapCache = cache;
    }

    private boolean validateAccessId(String accessId) throws InvalidArgumentException {
        return this.ldapClient.useLdap() && this.ldapClient.searchUsersAndGroups(accessId).size() == 1 || !this.ldapClient.useLdap() && ldapCache.validateAccessId(accessId).size() == 1;
    }
}

