/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaRole;
import pro.taskana.configuration.TaskanaEngineConfiguration;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.rest.resource.TaskanaUserInfoResource;
import pro.taskana.rest.resource.VersionResource;
import pro.taskana.security.CurrentUserContext;

@RestController
@RequestMapping(path={"/api/v1"}, produces={"application/json"})
public class TaskanaEngineController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineController.class);
    TaskanaEngineConfiguration taskanaEngineConfiguration;
    TaskanaEngine taskanaEngine;
    @Value(value="${version:Local build}")
    private String version;

    TaskanaEngineController(TaskanaEngineConfiguration taskanaEngineConfiguration, TaskanaEngine taskanaEngine) {
        this.taskanaEngineConfiguration = taskanaEngineConfiguration;
        this.taskanaEngine = taskanaEngine;
    }

    @GetMapping(path={"/domains"})
    public ResponseEntity<List<String>> getDomains() {
        ResponseEntity response = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getDomains());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getDomains(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/classification-categories"})
    public ResponseEntity<List<String>> getClassificationCategories(String type) {
        LOGGER.debug("Entry to getClassificationCategories(type = {})", (Object)type);
        if (type != null) {
            ResponseEntity response = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getClassificationCategoriesByType(type));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from getClassificationCategories(), returning {}", (Object)response);
            }
            return response;
        }
        ResponseEntity response = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getAllClassificationCategories());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getClassificationCategories(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/classification-types"})
    public ResponseEntity<List<String>> getClassificationTypes() {
        ResponseEntity response = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getClassificationTypes());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getClassificationTypes(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/current-user-info"})
    public ResponseEntity<TaskanaUserInfoResource> getCurrentUserInfo() {
        LOGGER.debug("Entry to getCurrentUserInfo()");
        TaskanaUserInfoResource resource = new TaskanaUserInfoResource();
        resource.setUserId(CurrentUserContext.getUserid());
        resource.setGroupIds(CurrentUserContext.getGroupIds());
        for (TaskanaRole role : this.taskanaEngineConfiguration.getRoleMap().keySet()) {
            if (!this.taskanaEngine.isUserInRole(new TaskanaRole[]{role})) continue;
            resource.getRoles().add(role);
        }
        ResponseEntity response = ResponseEntity.ok((Object)((Object)resource));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getCurrentUserInfo(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/history-provider-enabled"})
    public ResponseEntity<Boolean> getIsHistoryProviderEnabled() {
        ResponseEntity response = ResponseEntity.ok((Object)((TaskanaEngineImpl)this.taskanaEngine).getHistoryEventProducer().isEnabled());
        LOGGER.debug("Exit from getIsHistoryProviderEnabled(), returning {}", (Object)response);
        return response;
    }

    @GetMapping(path={"/version"})
    public ResponseEntity<VersionResource> currentVersion() {
        LOGGER.debug("Entry to currentVersion()");
        VersionResource resource = new VersionResource();
        resource.setVersion(TaskanaEngineConfiguration.class.getPackage().getImplementationVersion());
        ResponseEntity response = ResponseEntity.ok((Object)((Object)resource));
        LOGGER.debug("Exit from currentVersion(), returning {}", (Object)response);
        return response;
    }
}

