/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.time.Instant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketService;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.WorkbasketImpl;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.WorkbasketResource;

@Component
public class WorkbasketResourceAssembler {
    @Autowired
    private WorkbasketService workbasketService;

    public WorkbasketResource toResource(Workbasket wb) throws NotAuthorizedException, WorkbasketNotFoundException {
        WorkbasketResource resource = new WorkbasketResource(wb);
        return this.addLinks(resource, wb);
    }

    public Workbasket toModel(WorkbasketResource wbResource) {
        WorkbasketImpl workbasket = (WorkbasketImpl)this.workbasketService.newWorkbasket(wbResource.key, wbResource.domain);
        BeanUtils.copyProperties((Object)((Object)wbResource), (Object)workbasket);
        workbasket.setId(wbResource.workbasketId);
        if (wbResource.modified != null) {
            workbasket.setModified(Instant.parse(wbResource.modified));
        }
        if (wbResource.created != null) {
            workbasket.setCreated(Instant.parse(wbResource.created));
        }
        return workbasket;
    }

    private WorkbasketResource addLinks(WorkbasketResource resource, Workbasket wb) throws NotAuthorizedException, WorkbasketNotFoundException {
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasket(wb.getId())).withSelfRel());
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getDistributionTargets(wb.getId())).withRel("distributionTargets"));
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasketAccessItems(wb.getId())).withRel("accessItems"));
        resource.add(ControllerLinkBuilder.linkTo(WorkbasketController.class).withRel("allWorkbaskets"));
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).removeDistributionTargetForWorkbasketId(wb.getId())).withRel("removeDistributionTargets"));
        return resource;
    }
}

