/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketSummary;
import pro.taskana.impl.WorkbasketImpl;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.PagedResources;
import pro.taskana.rest.resource.WorkbasketSummaryListResource;
import pro.taskana.rest.resource.WorkbasketSummaryResource;
import pro.taskana.rest.resource.links.PageLinks;

@Component
public class WorkbasketSummaryResourceAssembler
extends ResourceAssemblerSupport<WorkbasketSummary, WorkbasketSummaryResource> {
    @Autowired
    private WorkbasketService workbasketService;

    public WorkbasketSummaryResourceAssembler() {
        super(WorkbasketController.class, WorkbasketSummaryResource.class);
    }

    public WorkbasketSummaryResource toResource(WorkbasketSummary workbasketSummary) {
        return new WorkbasketSummaryResource(workbasketSummary);
    }

    @PageLinks(value=WorkbasketController.class)
    public WorkbasketSummaryListResource toResources(List<WorkbasketSummary> entities, PagedResources.PageMetadata pageMetadata) {
        return new WorkbasketSummaryListResource((Collection<WorkbasketSummaryResource>)this.toResources(entities), pageMetadata, new Link[0]);
    }

    public WorkbasketSummary toModel(WorkbasketSummaryResource resource) {
        WorkbasketImpl workbasket = (WorkbasketImpl)this.workbasketService.newWorkbasket(resource.getKey(), resource.getDomain());
        workbasket.setId(resource.getWorkbasketId());
        BeanUtils.copyProperties((Object)((Object)resource), (Object)workbasket);
        return workbasket.asSummary();
    }
}

