/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.MultiValueMap;
import pro.taskana.BaseQuery;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.rest.resource.PagedResources;

public abstract class AbstractPagingController {
    private static final String PAGING_PAGE = "page";
    private static final String PAGING_PAGE_SIZE = "page-size";

    protected String[] extractCommaSeparatedFields(List<String> list) {
        ArrayList values = new ArrayList();
        if (list != null) {
            list.forEach(item -> values.addAll(Arrays.asList(item.split(","))));
        }
        return values.toArray(new String[0]);
    }

    protected void validateNoInvalidParameterIsLeft(MultiValueMap<String, String> params) throws InvalidArgumentException {
        if (!params.isEmpty()) {
            throw new InvalidArgumentException("Invalid parameter specified: " + params.keySet());
        }
    }

    protected PagedResources.PageMetadata getPageMetadata(MultiValueMap<String, String> params, BaseQuery<?, ?> query) throws InvalidArgumentException {
        PagedResources.PageMetadata pageMetadata = null;
        if (this.hasPagingInformationInParams(params)) {
            long totalElements = query.count();
            pageMetadata = this.initPageMetadata(params, totalElements);
            this.validateNoInvalidParameterIsLeft(params);
        } else {
            this.validateNoInvalidParameterIsLeft(params);
        }
        return pageMetadata;
    }

    protected <T> List<T> getQueryList(BaseQuery<T, ?> query, PagedResources.PageMetadata pageMetadata) {
        List resultList = pageMetadata != null ? query.listPage((int)pageMetadata.getNumber(), (int)pageMetadata.getSize()) : query.list();
        return resultList;
    }

    private boolean hasPagingInformationInParams(MultiValueMap<String, String> params) {
        return params.getFirst((Object)PAGING_PAGE) != null;
    }

    protected PagedResources.PageMetadata initPageMetadata(MultiValueMap<String, String> param, long totalElements) throws InvalidArgumentException {
        long page;
        long pageSize = this.getPageSize(param);
        PagedResources.PageMetadata pageMetadata = new PagedResources.PageMetadata(pageSize, page = this.getPage(param), totalElements >= 0L ? totalElements : Integer.MAX_VALUE);
        if (pageMetadata.getNumber() > pageMetadata.getTotalPages()) {
            pageMetadata = new PagedResources.PageMetadata(pageSize, pageMetadata.getTotalPages(), totalElements);
        }
        return pageMetadata;
    }

    protected PagedResources.PageMetadata initPageMetadata(String pagesizeParam, String pageParam, long totalElements) throws InvalidArgumentException {
        long page;
        long pageSize;
        try {
            pageSize = Long.parseLong(pagesizeParam);
            page = Long.parseLong(pageParam);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("page and pageSize must be a integer value.", e.getCause());
        }
        PagedResources.PageMetadata pageMetadata = new PagedResources.PageMetadata(pageSize, page, totalElements);
        if (pageMetadata.getNumber() > pageMetadata.getTotalPages()) {
            pageMetadata = new PagedResources.PageMetadata(pageSize, pageMetadata.getTotalPages(), totalElements);
        }
        return pageMetadata;
    }

    private long getPage(MultiValueMap<String, String> params) throws InvalidArgumentException {
        String param = (String)params.getFirst((Object)PAGING_PAGE);
        params.remove((Object)PAGING_PAGE);
        try {
            return Long.parseLong(param != null ? param : "1");
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("page must be a integer value.", e.getCause());
        }
    }

    private long getPageSize(MultiValueMap<String, String> params) throws InvalidArgumentException {
        String param = (String)params.getFirst((Object)PAGING_PAGE_SIZE);
        params.remove((Object)PAGING_PAGE_SIZE);
        try {
            return param != null ? Long.valueOf(param) : Integer.MAX_VALUE;
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("page-size must be a integer value.", e.getCause());
        }
    }
}

