/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import pro.taskana.Classification;
import pro.taskana.ClassificationQuery;
import pro.taskana.ClassificationService;
import pro.taskana.ClassificationSummary;
import pro.taskana.exceptions.ClassificationAlreadyExistException;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.ConcurrencyException;
import pro.taskana.exceptions.DomainNotFoundException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.rest.resource.ClassificationResource;
import pro.taskana.rest.resource.ClassificationResourceAssembler;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class ClassificationDefinitionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationDefinitionController.class);
    private ClassificationService classificationService;
    private ClassificationResourceAssembler classificationResourceAssembler;

    ClassificationDefinitionController(ClassificationService classificationService, ClassificationResourceAssembler classificationResourceAssembler) {
        this.classificationService = classificationService;
        this.classificationResourceAssembler = classificationResourceAssembler;
    }

    @GetMapping(path={"/api/v1/classification-definitions"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<ClassificationResource>> exportClassifications(@RequestParam(required=false) String domain) throws ClassificationNotFoundException {
        LOGGER.debug("Entry to exportClassifications(domain= {})", (Object)domain);
        ClassificationQuery query = this.classificationService.createClassificationQuery();
        List summaries = domain != null ? query.domainIn(new String[]{domain}).list() : query.list();
        ArrayList<ClassificationResource> export = new ArrayList<ClassificationResource>();
        for (ClassificationSummary summary : summaries) {
            Classification classification = this.classificationService.getClassification(summary.getKey(), summary.getDomain());
            export.add(this.classificationResourceAssembler.toDefinition(classification));
        }
        ResponseEntity response = ResponseEntity.ok(export);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from exportClassifications(), returning {}", (Object)response);
        }
        return response;
    }

    @PostMapping(path={"/api/v1/classification-definitions"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Void> importClassifications(@RequestParam(value="file") MultipartFile file) throws InvalidArgumentException, NotAuthorizedException, ConcurrencyException, ClassificationNotFoundException, ClassificationAlreadyExistException, DomainNotFoundException, IOException {
        LOGGER.debug("Entry to importClassifications()");
        Map<String, String> systemIds = this.getSystemIds();
        List<ClassificationResource> classificationsResources = this.extractClassificationResourcesFromFile(file);
        this.checkForDuplicates(classificationsResources);
        Map<Classification, String> childrenInFile = this.mapChildrenToParentKeys(classificationsResources, systemIds);
        this.insertOrUpdateClassificationsWithoutParent(classificationsResources, systemIds);
        this.updateParentChildrenRelations(childrenInFile);
        ResponseEntity response = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from importClassifications(), returning {}", (Object)response);
        return response;
    }

    private Map<String, String> getSystemIds() {
        Map<String, String> systemIds = this.classificationService.createClassificationQuery().list().stream().collect(Collectors.toMap(i -> i.getKey() + "|" + i.getDomain(), ClassificationSummary::getId));
        return systemIds;
    }

    private List<ClassificationResource> extractClassificationResourcesFromFile(MultipartFile file) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List classificationsDefinitions = (List)mapper.readValue(file.getInputStream(), (TypeReference)new TypeReference<List<ClassificationResource>>(){});
        return classificationsDefinitions;
    }

    private void checkForDuplicates(List<ClassificationResource> classificationList) {
        ArrayList<String> identifiers = new ArrayList<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (ClassificationResource classification : classificationList) {
            String identifier = classification.key + "|" + classification.domain;
            if (identifiers.contains(identifier)) {
                duplicates.add(identifier);
                continue;
            }
            identifiers.add(identifier);
        }
        if (!duplicates.isEmpty()) {
            throw new DuplicateKeyException("The 'key|domain'-identifier is not unique for the value(s): " + ((Object)duplicates).toString());
        }
    }

    private Map<Classification, String> mapChildrenToParentKeys(List<ClassificationResource> classificationResources, Map<String, String> systemIds) {
        LOGGER.debug("Entry to mapChildrenToParentKeys()");
        HashMap<Classification, String> childrenInFile = new HashMap<Classification, String>();
        HashSet newKeysWithDomain = new HashSet();
        classificationResources.forEach(cl -> newKeysWithDomain.add(cl.getKey() + "|" + cl.getDomain()));
        for (ClassificationResource cl2 : classificationResources) {
            cl2.parentId = cl2.parentId == null ? "" : cl2.parentId;
            String string = cl2.parentKey = cl2.parentKey == null ? "" : cl2.parentKey;
            if (!cl2.getParentId().equals("") && cl2.getParentKey().equals("")) {
                for (ClassificationResource parent : classificationResources) {
                    if (!cl2.getParentId().equals(parent.getClassificationId())) continue;
                    cl2.setParentKey(parent.getKey());
                }
            }
            String parentKeyAndDomain = cl2.parentKey + "|" + cl2.domain;
            if (cl2.getParentKey().isEmpty() || cl2.getParentKey().equals("") || !newKeysWithDomain.contains(parentKeyAndDomain) && !systemIds.containsKey(parentKeyAndDomain)) continue;
            childrenInFile.put(this.classificationResourceAssembler.toModel(cl2), cl2.getParentKey());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from mapChildrenToParentKeys(), returning {}", (Object)LoggerUtils.mapToString(childrenInFile));
        }
        return childrenInFile;
    }

    private void insertOrUpdateClassificationsWithoutParent(List<ClassificationResource> classificationResources, Map<String, String> systemIds) throws ClassificationNotFoundException, NotAuthorizedException, InvalidArgumentException, ClassificationAlreadyExistException, DomainNotFoundException, ConcurrencyException {
        LOGGER.debug("Entry to insertOrUpdateClassificationsWithoutParent()");
        for (ClassificationResource classificationResource : classificationResources) {
            classificationResource.setParentKey(null);
            classificationResource.setParentId(null);
            classificationResource.setClassificationId(null);
            String systemId = systemIds.get(classificationResource.key + "|" + classificationResource.domain);
            if (systemId != null) {
                this.updateExistingClassification(classificationResource, systemId);
                continue;
            }
            this.classificationService.createClassification(this.classificationResourceAssembler.toModel(classificationResource));
        }
        LOGGER.debug("Exit from insertOrUpdateClassificationsWithoutParent()");
    }

    private void updateParentChildrenRelations(Map<Classification, String> childrenInFile) throws ClassificationNotFoundException, NotAuthorizedException, ConcurrencyException, InvalidArgumentException {
        LOGGER.debug("Entry to updateParentChildrenRelations()");
        for (Classification childRes : childrenInFile.keySet()) {
            Classification child = this.classificationService.getClassification(childRes.getKey(), childRes.getDomain());
            String parentKey = childrenInFile.get(childRes);
            String parentId = parentKey == null ? "" : this.classificationService.getClassification(parentKey, childRes.getDomain()).getId();
            child.setParentKey(parentKey);
            child.setParentId(parentId);
            this.classificationService.updateClassification(child);
        }
        LOGGER.debug("Exit from updateParentChildrenRelations()");
    }

    private void updateExistingClassification(ClassificationResource cl, String systemId) throws ClassificationNotFoundException, NotAuthorizedException, ConcurrencyException, InvalidArgumentException {
        LOGGER.debug("Entry to updateExistingClassification()");
        Classification currentClassification = this.classificationService.getClassification(systemId);
        if (cl.getType() != null && !cl.getType().equals(currentClassification.getType())) {
            throw new InvalidArgumentException("Can not change the type of a classification.");
        }
        currentClassification.setCategory(cl.category);
        currentClassification.setIsValidInDomain(cl.isValidInDomain);
        currentClassification.setName(cl.name);
        currentClassification.setParentId(cl.parentId);
        currentClassification.setParentKey(cl.parentKey);
        currentClassification.setDescription(cl.description);
        currentClassification.setPriority(cl.priority);
        currentClassification.setServiceLevel(cl.serviceLevel);
        currentClassification.setApplicationEntryPoint(cl.applicationEntryPoint);
        currentClassification.setCustom1(cl.custom1);
        currentClassification.setCustom2(cl.custom2);
        currentClassification.setCustom3(cl.custom3);
        currentClassification.setCustom4(cl.custom4);
        currentClassification.setCustom5(cl.custom5);
        currentClassification.setCustom6(cl.custom6);
        currentClassification.setCustom7(cl.custom7);
        currentClassification.setCustom8(cl.custom8);
        this.classificationService.updateClassification(currentClassification);
        LOGGER.debug("Exit from updateExistingClassification()");
    }
}

