/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.DomainNotFoundException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketAccessItemAlreadyExistException;
import pro.taskana.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.rest.resource.WorkbasketDefinitionResource;
import pro.taskana.rest.resource.WorkbasketDefinitionResourceAssembler;
import pro.taskana.rest.resource.WorkbasketResource;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class WorkbasketDefinitionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketDefinitionController.class);
    private WorkbasketService workbasketService;
    private WorkbasketDefinitionResourceAssembler workbasketDefinitionAssembler;

    WorkbasketDefinitionController(WorkbasketService workbasketService, WorkbasketDefinitionResourceAssembler workbasketDefinitionAssembler) {
        this.workbasketService = workbasketService;
        this.workbasketDefinitionAssembler = workbasketDefinitionAssembler;
    }

    @GetMapping(path={"/api/v1/workbasket-definitions"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<List<WorkbasketDefinitionResource>> exportWorkbaskets(@RequestParam(required=false) String domain) throws NotAuthorizedException, WorkbasketNotFoundException {
        LOGGER.debug("Entry to exportWorkbaskets(domain= {})", (Object)domain);
        WorkbasketQuery workbasketQuery = this.workbasketService.createWorkbasketQuery();
        List workbasketSummaryList = domain != null ? workbasketQuery.domainIn(new String[]{domain}).list() : workbasketQuery.list();
        ArrayList<WorkbasketDefinitionResource> basketExports = new ArrayList<WorkbasketDefinitionResource>();
        for (WorkbasketSummary summary : workbasketSummaryList) {
            Workbasket workbasket = this.workbasketService.getWorkbasket(summary.getId());
            basketExports.add(this.workbasketDefinitionAssembler.toResource(workbasket));
        }
        ResponseEntity response = ResponseEntity.ok(basketExports);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from exportWorkbaskets(), returning {}", (Object)response);
        }
        return response;
    }

    @PostMapping(path={"/api/v1/workbasket-definitions"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Void> importWorkbaskets(@RequestParam(value="file") MultipartFile file) throws IOException, NotAuthorizedException, DomainNotFoundException, InvalidWorkbasketException, WorkbasketAlreadyExistException, WorkbasketNotFoundException, InvalidArgumentException, WorkbasketAccessItemAlreadyExistException {
        LOGGER.debug("Entry to importWorkbaskets()");
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        List definitions = (List)mapper.readValue(file.getInputStream(), (TypeReference)new TypeReference<List<WorkbasketDefinitionResource>>(){});
        Map<String, String> systemIds = this.workbasketService.createWorkbasketQuery().list().stream().collect(Collectors.toMap(this::logicalId, WorkbasketSummary::getId));
        this.checkForDuplicates(definitions);
        HashMap<String, String> idConversion = new HashMap<String, String>();
        for (WorkbasketDefinitionResource definition : definitions) {
            Workbasket workbasket;
            Workbasket importedWb = this.workbasketDefinitionAssembler.toModel(definition.getWorkbasket());
            if (systemIds.containsKey(this.logicalId(importedWb))) {
                workbasket = this.workbasketService.updateWorkbasket(importedWb);
            } else {
                Workbasket wbWithoutId = this.removeId(importedWb);
                workbasket = this.workbasketService.createWorkbasket(wbWithoutId);
            }
            for (WorkbasketAccessItem workbasketAccessItem : this.workbasketService.getWorkbasketAccessItems(workbasket.getId())) {
                this.workbasketService.deleteWorkbasketAccessItem(workbasketAccessItem.getId());
            }
            for (WorkbasketAccessItem workbasketAccessItem : definition.getAuthorizations()) {
                this.workbasketService.createWorkbasketAccessItem(workbasketAccessItem);
            }
            idConversion.put(importedWb.getId(), workbasket.getId());
        }
        for (WorkbasketDefinitionResource definition : definitions) {
            ArrayList distributionTargets = new ArrayList();
            for (String oldId : definition.getDistributionTargets()) {
                if (idConversion.containsKey(oldId)) {
                    distributionTargets.add(idConversion.get(oldId));
                    continue;
                }
                throw new InvalidWorkbasketException(String.format("invalid import state: Workbasket '%s' does not exist in the given import list", oldId));
            }
            this.workbasketService.setDistributionTargets((String)idConversion.get(definition.getWorkbasket().getWorkbasketId()), distributionTargets);
        }
        ResponseEntity response = ResponseEntity.noContent().build();
        LOGGER.debug("Exit from importWorkbaskets(), returning {}", (Object)response);
        return response;
    }

    private Workbasket removeId(Workbasket importedWb) {
        WorkbasketResource wbRes = new WorkbasketResource(importedWb);
        wbRes.setWorkbasketId(null);
        return this.workbasketDefinitionAssembler.toModel(wbRes);
    }

    private void checkForDuplicates(List<WorkbasketDefinitionResource> definitions) {
        ArrayList<String> identifiers = new ArrayList<String>();
        HashSet<String> duplicates = new HashSet<String>();
        for (WorkbasketDefinitionResource definition : definitions) {
            String identifier = this.logicalId(this.workbasketDefinitionAssembler.toModel(definition.getWorkbasket()));
            if (identifiers.contains(identifier)) {
                duplicates.add(identifier);
                continue;
            }
            identifiers.add(identifier);
        }
        if (!duplicates.isEmpty()) {
            throw new DuplicateKeyException("The 'key|domain'-identifier is not unique for the value(s): " + ((Object)duplicates).toString());
        }
    }

    private String logicalId(WorkbasketSummary workbasket) {
        return this.logicalId(workbasket.getKey(), workbasket.getDomain());
    }

    private String logicalId(Workbasket workbasket) {
        return this.logicalId(workbasket.getKey(), workbasket.getDomain());
    }

    private String logicalId(String key, String domain) {
        return key + "|" + domain;
    }
}

