/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.time.Instant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;
import pro.taskana.Classification;
import pro.taskana.ClassificationService;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.SystemException;
import pro.taskana.impl.ClassificationImpl;
import pro.taskana.rest.ClassificationController;
import pro.taskana.rest.resource.ClassificationResource;

@Component
public class ClassificationResourceAssembler
extends ResourceAssemblerSupport<Classification, ClassificationResource> {
    final ClassificationService classificationService;

    @Autowired
    public ClassificationResourceAssembler(ClassificationService classificationService) {
        super(ClassificationController.class, ClassificationResource.class);
        this.classificationService = classificationService;
    }

    public ClassificationResource toResource(Classification classification) {
        ClassificationResource resource = new ClassificationResource(classification);
        try {
            resource.add(ControllerLinkBuilder.linkTo(((ClassificationController)ControllerLinkBuilder.methodOn(ClassificationController.class, (Object[])new Object[0])).getClassification(classification.getId())).withSelfRel());
        }
        catch (ClassificationNotFoundException e) {
            throw new SystemException("caught unexpected Exception.", e.getCause());
        }
        return resource;
    }

    public ClassificationResource toDefinition(Classification classification) {
        ClassificationResource resource = new ClassificationResource(classification);
        resource.add(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(ClassificationController.class).slash((Object)classification.getId())).withSelfRel());
        return resource;
    }

    public Classification toModel(ClassificationResource classificationResource) {
        ClassificationImpl classification = (ClassificationImpl)this.classificationService.newClassification(classificationResource.domain, classificationResource.key, classificationResource.type);
        BeanUtils.copyProperties((Object)((Object)classificationResource), (Object)classification);
        classification.setId(classificationResource.getClassificationId());
        if (classificationResource.getCreated() != null) {
            classification.setCreated(Instant.parse(classificationResource.getCreated()));
        }
        if (classificationResource.getModified() != null) {
            classification.setModified(Instant.parse(classificationResource.getModified()));
        }
        return classification;
    }
}

