/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.util.Arrays;
import java.util.List;
import org.springframework.hateoas.ResourceSupport;

public class ReportResource
extends ResourceSupport {
    private MetaInformation meta;
    private List<RowResource> rows;
    private List<RowResource> sumRow;

    public ReportResource(MetaInformation meta, List<RowResource> rows, List<RowResource> sumRow) {
        this.meta = meta;
        this.rows = rows;
        this.sumRow = sumRow;
    }

    public MetaInformation getMeta() {
        return this.meta;
    }

    public List<RowResource> getRows() {
        return this.rows;
    }

    public List<RowResource> getSumRow() {
        return this.sumRow;
    }

    public static class MetaInformation {
        private static final String TOTAL_DESC = "Total";
        private String name;
        private String date;
        private String[] header;
        private String[] rowDesc;

        public MetaInformation(String name, String date, String[] header, String[] rowDesc) {
            this.name = name;
            this.date = date;
            this.header = header;
            this.rowDesc = rowDesc;
        }

        public String getTotalDesc() {
            return TOTAL_DESC;
        }

        public String getName() {
            return this.name;
        }

        public String getDate() {
            return this.date;
        }

        public String[] getHeader() {
            return this.header;
        }

        public String[] getRowDesc() {
            return this.rowDesc;
        }

        public String toString() {
            return String.format("MetaInformation [name= %s, date= %s, header= %s, rowDesc= %s]", this.name, this.date, Arrays.toString(this.header), Arrays.toString(this.rowDesc));
        }
    }

    public static class RowResource {
        private int[] cells;
        private int total;
        private int depth;
        private String[] desc;
        private boolean display;

        public RowResource(int[] cells, int total, int depth, String[] desc, boolean display) {
            this.cells = cells;
            this.total = total;
            this.depth = depth;
            this.desc = desc;
            this.display = display;
        }

        public int[] getCells() {
            return this.cells;
        }

        public int getTotal() {
            return this.total;
        }

        public int getDepth() {
            return this.depth;
        }

        public String[] getDesc() {
            return this.desc;
        }

        public boolean isDisplay() {
            return this.display;
        }

        public String toString() {
            return String.format("RowResourde [cells=%s, total=%d, depth=%d, desc=%s", Arrays.toString(this.cells), this.total, this.depth, Arrays.toString(this.desc));
        }
    }
}

