/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.Date;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.WebRequest;

public class TaskanaErrorData {
    private Date timestamp = new Date();
    private int status;
    private String error;
    private String exception;
    private String message;
    private String path;

    TaskanaErrorData(HttpStatus stat, Exception ex, WebRequest req) {
        this.status = stat.value();
        this.error = stat.name();
        this.exception = ex.getClass().getName();
        this.message = ex.getMessage();
        this.path = req.getDescription(false);
        if (this.path != null && this.path.startsWith("uri=")) {
            this.path = this.path.substring(4);
        }
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int getStatus() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public String getException() {
        return this.exception;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "TaskanaErrorData [timestamp=" + this.timestamp + ", status=" + this.status + ", error=" + this.error + ", exception=" + this.exception + ", message=" + this.message + ", path=" + this.path + "]";
    }
}

