/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.WorkbasketAccessItemImpl;
import pro.taskana.impl.WorkbasketImpl;
import pro.taskana.rest.resource.WorkbasketDefinitionResource;
import pro.taskana.rest.resource.WorkbasketResource;
import pro.taskana.rest.resource.WorkbasketResourceWithoutLinks;

@Component
public class WorkbasketDefinitionResourceAssembler {
    @Autowired
    private WorkbasketService workbasketService;

    public WorkbasketDefinitionResource toResource(Workbasket workbasket) throws NotAuthorizedException, WorkbasketNotFoundException {
        WorkbasketResourceWithoutLinks basket = new WorkbasketResourceWithoutLinks(workbasket);
        ArrayList<WorkbasketAccessItemImpl> authorizations = new ArrayList<WorkbasketAccessItemImpl>();
        for (WorkbasketAccessItem accessItem : this.workbasketService.getWorkbasketAccessItems(basket.getWorkbasketId())) {
            authorizations.add((WorkbasketAccessItemImpl)accessItem);
        }
        Set<String> distroTargets = this.workbasketService.getDistributionTargets(workbasket.getId()).stream().map(WorkbasketSummary::getId).collect(Collectors.toSet());
        return new WorkbasketDefinitionResource(basket, distroTargets, authorizations);
    }

    public Workbasket toModel(WorkbasketResource wbResource) {
        WorkbasketImpl workbasket = (WorkbasketImpl)this.workbasketService.newWorkbasket(wbResource.key, wbResource.domain);
        BeanUtils.copyProperties((Object)((Object)wbResource), (Object)workbasket);
        workbasket.setId(wbResource.workbasketId);
        if (wbResource.getModified() != null) {
            workbasket.setModified(Instant.parse(wbResource.modified));
        }
        if (wbResource.getCreated() != null) {
            workbasket.setCreated(Instant.parse(wbResource.created));
        }
        return workbasket;
    }
}

