/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.ldap.filter.WhitespaceWildcardsFilter;
import org.springframework.stereotype.Component;
import pro.taskana.common.api.LoggerUtils;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.ldap.LdapSettings;
import pro.taskana.rest.resource.AccessIdResource;

@Component
public class LdapClient {
    static final String MISSING_CONFIGURATION_S = "LdapClient was called but is not active due to missing configuration: %s ";
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapClient.class);
    private static final String CN = "cn";
    private boolean active = false;
    @Autowired
    private Environment env;
    @Autowired(required=false)
    private LdapTemplate ldapTemplate;
    private int minSearchForLength;
    private int maxNumberOfReturnedAccessIds;
    private String message;

    public List<AccessIdResource> searchUsersAndGroups(String name) throws InvalidArgumentException {
        LOGGER.debug("entry to searchUsersAndGroups(name = {})", (Object)name);
        this.isInitOrFail();
        this.testMinSearchForLength(name);
        ArrayList<AccessIdResource> accessIds = new ArrayList<AccessIdResource>(this.searchUsersByName(name));
        accessIds.addAll(this.searchGroupsByName(name));
        try {
            AccessIdResource groupByDn = this.searchGroupByDn(name);
            if (groupByDn != null) {
                accessIds.add(this.searchGroupByDn(name));
            }
        }
        catch (Throwable t) {
            LOGGER.error("unexpected error while searching group by dn", t);
        }
        this.sortListOfAccessIdResources(accessIds);
        List<AccessIdResource> result = this.getFirstPageOfaResultList(accessIds);
        LOGGER.debug("exit from searchUsersAndGroups(name = {}). Returning {} users and groups: {}", new Object[]{name, accessIds.size(), LoggerUtils.listToString(result)});
        return result;
    }

    public List<AccessIdResource> searchUsersByName(String name) throws InvalidArgumentException {
        LOGGER.debug("entry to searchUsersByName(name = {}).", (Object)name);
        this.isInitOrFail();
        this.testMinSearchForLength(name);
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getUserSearchFilterName(), this.getUserSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserFirstnameAttribute(), name));
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserLastnameAttribute(), name));
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserIdAttribute(), name));
        andFilter.and((Filter)orFilter);
        String[] userAttributesToReturn = new String[]{this.getUserFirstnameAttribute(), this.getUserLastnameAttribute(), this.getUserIdAttribute()};
        List accessIds = this.ldapTemplate.search(this.getUserSearchBase(), andFilter.encode(), 2, userAttributesToReturn, (ContextMapper)new UserContextMapper());
        LOGGER.debug("exit from searchUsersByName. Retrieved the following users: {}.", (Object)LoggerUtils.listToString((List)accessIds));
        return accessIds;
    }

    public List<AccessIdResource> searchGroupsByName(String name) throws InvalidArgumentException {
        LOGGER.debug("entry to searchGroupsByName(name = {}).", (Object)name);
        this.isInitOrFail();
        this.testMinSearchForLength(name);
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getGroupSearchFilterName(), this.getGroupSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getGroupNameAttribute(), name));
        if (!CN.equals(this.getGroupNameAttribute())) {
            orFilter.or((Filter)new WhitespaceWildcardsFilter(CN, name));
        }
        andFilter.and((Filter)orFilter);
        List accessIds = this.ldapTemplate.search(this.getGroupSearchBase(), andFilter.encode(), 2, this.getLookUpGoupAttributesToReturn(), (ContextMapper)new GroupContextMapper());
        LOGGER.debug("Exit from searchGroupsByName. Retrieved the following groups: {}", (Object)LoggerUtils.listToString((List)accessIds));
        return accessIds;
    }

    public AccessIdResource searchGroupByDn(String name) {
        LOGGER.debug("entry to searchGroupByDn(name = {}).", (Object)name);
        this.isInitOrFail();
        String nameWithoutBaseDn = this.getNameWithoutBaseDn(name);
        LOGGER.debug("Removes baseDN {} from given DN. New DN to be used: {}", (Object)this.getBaseDn(), (Object)nameWithoutBaseDn);
        AccessIdResource accessId = (AccessIdResource)this.ldapTemplate.lookup(nameWithoutBaseDn, this.getLookUpGoupAttributesToReturn(), (ContextMapper)new GroupContextMapper());
        LOGGER.debug("Exit from searchGroupByDn. Retrieved the following group: {}", (Object)accessId);
        return accessId;
    }

    public List<AccessIdResource> searchGroupsofUsersIsMember(String name) throws InvalidArgumentException {
        LOGGER.debug("entry to searchGroupsofUsersIsMember(name = {}).", (Object)name);
        this.isInitOrFail();
        this.testMinSearchForLength(name);
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new WhitespaceWildcardsFilter(this.getGroupNameAttribute(), ""));
        andFilter.and((Filter)new EqualsFilter(this.getGroupsOfUser(), name));
        String[] userAttributesToReturn = new String[]{this.getUserIdAttribute(), this.getGroupNameAttribute()};
        List accessIds = this.ldapTemplate.search(this.getGroupSearchBase(), andFilter.encode(), 2, userAttributesToReturn, (ContextMapper)new GroupContextMapper());
        LOGGER.debug("exit from searchGroupsofUsersIsMember. Retrieved the following users: {}.", (Object)LoggerUtils.listToString((List)accessIds));
        return accessIds;
    }

    public boolean useLdap() {
        String useLdap = LdapSettings.TASKANA_LDAP_USE_LDAP.getValueFromEnv(this.env);
        return Boolean.parseBoolean(useLdap);
    }

    public String getUserSearchBase() {
        return LdapSettings.TASKANA_LDAP_USER_SEARCH_BASE.getValueFromEnv(this.env);
    }

    public String getUserSearchFilterName() {
        return LdapSettings.TASKANA_LDAP_USER_SEARCH_FILTER_NAME.getValueFromEnv(this.env);
    }

    public String getUserSearchFilterValue() {
        return LdapSettings.TASKANA_LDAP_USER_SEARCH_FILTER_VALUE.getValueFromEnv(this.env);
    }

    public String getUserFirstnameAttribute() {
        return LdapSettings.TASKANA_LDAP_USER_FIRSTNAME_ATTRIBUTE.getValueFromEnv(this.env);
    }

    public String getUserLastnameAttribute() {
        return LdapSettings.TASKANA_LDAP_USER_LASTNAME_ATTRIBUTE.getValueFromEnv(this.env);
    }

    public String getUserIdAttribute() {
        return LdapSettings.TASKANA_LDAP_USER_ID_ATTRIBUTE.getValueFromEnv(this.env);
    }

    public String getGroupSearchBase() {
        return LdapSettings.TASKANA_LDAP_GROUP_SEARCH_BASE.getValueFromEnv(this.env);
    }

    public String getBaseDn() {
        return LdapSettings.TASKANA_LDAP_BASE_DN.getValueFromEnv(this.env);
    }

    public String getGroupSearchFilterName() {
        return LdapSettings.TASKANA_LDAP_GROUP_SEARCH_FILTER_NAME.getValueFromEnv(this.env);
    }

    public String getGroupSearchFilterValue() {
        return LdapSettings.TASKANA_LDAP_GROUP_SEARCH_FILTER_VALUE.getValueFromEnv(this.env);
    }

    public String getGroupNameAttribute() {
        return LdapSettings.TASKANA_LDAP_GROUP_NAME_ATTRIBUTE.getValueFromEnv(this.env);
    }

    public int calcMinSearchForLength(int defaultValue) {
        String envValue = LdapSettings.TASKANA_LDAP_MIN_SEARCH_FOR_LENGTH.getValueFromEnv(this.env);
        if (envValue == null || envValue.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(envValue);
    }

    public int getMinSearchForLength() {
        return this.minSearchForLength;
    }

    public int calcMaxNumberOfReturnedAccessIds(int defaultValue) {
        String envValue = LdapSettings.TASKANA_LDAP_MAX_NUMBER_OF_RETURNED_ACCESS_IDS.getValueFromEnv(this.env);
        if (envValue == null || envValue.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(envValue);
    }

    public int getMaxNumberOfReturnedAccessIds() {
        return this.maxNumberOfReturnedAccessIds;
    }

    public String getGroupsOfUser() {
        return LdapSettings.TASKANA_LDAP_GROUPS_OF_USER.getValueFromEnv(this.env);
    }

    public boolean isGroup(String accessId) {
        return accessId.contains(this.getGroupSearchBase());
    }

    List<AccessIdResource> getFirstPageOfaResultList(List<AccessIdResource> accessIds) {
        return accessIds.subList(0, Math.min(accessIds.size(), this.maxNumberOfReturnedAccessIds));
    }

    void isInitOrFail() {
        if (!this.active) {
            throw new SystemException(String.format(MISSING_CONFIGURATION_S, this.message));
        }
    }

    void sortListOfAccessIdResources(List<AccessIdResource> accessIds) {
        accessIds.sort((a, b) -> a.getAccessId().compareToIgnoreCase(b.getAccessId()));
    }

    String getNameWithoutBaseDn(String name) {
        return name.replaceAll("(?i)" + Pattern.quote("," + this.getBaseDn()), "");
    }

    String[] getLookUpGoupAttributesToReturn() {
        if (CN.equals(this.getGroupNameAttribute())) {
            return new String[]{CN};
        }
        return new String[]{this.getGroupNameAttribute(), CN};
    }

    @PostConstruct
    void init() {
        LOGGER.debug("Entry to init()");
        this.minSearchForLength = this.calcMinSearchForLength(3);
        this.maxNumberOfReturnedAccessIds = this.calcMaxNumberOfReturnedAccessIds(50);
        if (this.useLdap()) {
            this.ldapTemplate.setDefaultCountLimit(this.maxNumberOfReturnedAccessIds);
            List<LdapSettings> missingConfigurations = this.checkForMissingConfigurations();
            if (missingConfigurations.size() > 0) {
                this.message = String.format("taskana.ldap.useLdap is set to true, but following configurations are missing: %s", missingConfigurations);
                throw new SystemException(this.message);
            }
            this.active = true;
        }
        LOGGER.debug("Exit from init()");
    }

    List<LdapSettings> checkForMissingConfigurations() {
        return Arrays.stream(LdapSettings.values()).filter(p -> !p.equals((Object)LdapSettings.TASKANA_LDAP_MAX_NUMBER_OF_RETURNED_ACCESS_IDS)).filter(p -> !p.equals((Object)LdapSettings.TASKANA_LDAP_MIN_SEARCH_FOR_LENGTH)).filter(p -> Objects.isNull(p.getValueFromEnv(this.env))).collect(Collectors.toList());
    }

    void testMinSearchForLength(String name) throws InvalidArgumentException {
        if (name == null || name.length() < this.minSearchForLength) {
            throw new InvalidArgumentException(String.format("search for string %s is too short. Minimum Length is %s", name, this.getMinSearchForLength()));
        }
    }

    class UserContextMapper
    extends AbstractContextMapper<AccessIdResource> {
        UserContextMapper() {
        }

        public AccessIdResource doMapFromContext(DirContextOperations context) {
            AccessIdResource accessId = new AccessIdResource();
            accessId.setAccessId(context.getStringAttribute(LdapClient.this.getUserIdAttribute()));
            String firstName = context.getStringAttribute(LdapClient.this.getUserFirstnameAttribute());
            String lastName = context.getStringAttribute(LdapClient.this.getUserLastnameAttribute());
            accessId.setName(String.format("%s, %s", lastName, firstName));
            return accessId;
        }
    }

    class GroupContextMapper
    extends AbstractContextMapper<AccessIdResource> {
        GroupContextMapper() {
        }

        public AccessIdResource doMapFromContext(DirContextOperations context) {
            AccessIdResource accessId = new AccessIdResource();
            accessId.setAccessId(context.getNameInNamespace());
            accessId.setName(context.getStringAttribute(LdapClient.this.getGroupNameAttribute()));
            return accessId;
        }
    }
}

