/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.rest.TaskanaErrorData;
import pro.taskana.task.api.exceptions.InvalidOwnerException;
import pro.taskana.task.api.exceptions.InvalidStateException;
import pro.taskana.task.api.exceptions.TaskAlreadyExistException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.workbasket.api.exceptions.InvalidWorkbasketException;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedToQueryWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketInUseException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;

@Order(value=-2147483648)
@ControllerAdvice
public class TaskanaRestExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaRestExceptionHandler.class);

    @ExceptionHandler(value={InvalidArgumentException.class})
    protected ResponseEntity<Object> handleInvalidArgument(InvalidArgumentException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NotAuthorizedException.class})
    protected ResponseEntity<Object> handleNotAuthorized(NotAuthorizedException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={TaskNotFoundException.class})
    protected ResponseEntity<Object> handleTaskNotFound(TaskNotFoundException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={TaskAlreadyExistException.class})
    protected ResponseEntity<Object> handleTaskAlreadyExist(TaskAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={NotAuthorizedToQueryWorkbasketException.class})
    protected ResponseEntity<Object> handleNotAuthorizedToQueryWorkbasket(NotAuthorizedToQueryWorkbasketException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={InvalidStateException.class})
    protected ResponseEntity<Object> handleInvalidState(InvalidStateException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={InvalidOwnerException.class})
    protected ResponseEntity<Object> handleInvalidOwner(InvalidOwnerException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={ClassificationNotFoundException.class})
    protected ResponseEntity<Object> handleClassificationNotFound(ClassificationNotFoundException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ClassificationAlreadyExistException.class})
    protected ResponseEntity<Object> handleClassificationAlreadyExist(ClassificationAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    protected ResponseEntity<Object> handleDuplicateKey(DuplicateKeyException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={ConcurrencyException.class})
    protected ResponseEntity<Object> handleConcurrencyException(ConcurrencyException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={WorkbasketInUseException.class})
    protected ResponseEntity<Object> handleWorkbasketInUse(WorkbasketInUseException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.LOCKED);
    }

    @ExceptionHandler(value={WorkbasketAlreadyExistException.class})
    protected ResponseEntity<Object> handleWorkbasketAlreadyExist(WorkbasketAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={WorkbasketAccessItemAlreadyExistException.class})
    protected ResponseEntity<Object> handleWorkbasketAccessItemAlreadyExist(WorkbasketAccessItemAlreadyExistException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={WorkbasketNotFoundException.class})
    protected ResponseEntity<Object> handleWorkbasketNotFound(WorkbasketNotFoundException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={InvalidWorkbasketException.class})
    protected ResponseEntity<Object> handleInvalidWorkbasket(InvalidWorkbasketException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={DomainNotFoundException.class})
    protected ResponseEntity<Object> handleDomainNotFound(DomainNotFoundException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    protected ResponseEntity<Object> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException ex, WebRequest req) {
        return this.buildResponse((Exception)ex, req, HttpStatus.PAYLOAD_TOO_LARGE);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleGeneralException(Exception ex, WebRequest req) {
        return this.buildResponse(ex, req, HttpStatus.BAD_REQUEST);
    }

    private ResponseEntity<Object> buildResponse(Exception ex, WebRequest req, HttpStatus status) {
        TaskanaErrorData errorData = new TaskanaErrorData(status, ex, req);
        this.logError(ex, errorData);
        return ResponseEntity.status((HttpStatus)status).body((Object)errorData);
    }

    private void logError(Exception ex, TaskanaErrorData errorData) {
        LOGGER.error("Error occurred during processing of rest request:\n {}" + errorData.toString(), (Throwable)ex);
    }
}

