/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;
import pro.taskana.rest.AttachmentController;
import pro.taskana.rest.resource.AttachmentResource;
import pro.taskana.rest.resource.ClassificationSummaryResourceAssembler;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.models.Attachment;
import pro.taskana.task.internal.models.AttachmentImpl;

@Component
public class AttachmentResourceAssembler
extends ResourceAssemblerSupport<Attachment, AttachmentResource> {
    @Autowired
    private TaskService taskService;
    @Autowired
    private ClassificationSummaryResourceAssembler classificationAssembler;

    public AttachmentResourceAssembler() {
        super(AttachmentController.class, AttachmentResource.class);
    }

    public AttachmentResource toResource(Attachment attachment) {
        AttachmentResource resource = new AttachmentResource(attachment);
        resource.add(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(AttachmentController.class).slash((Object)attachment.getId())).withSelfRel());
        return resource;
    }

    public List<Attachment> toModel(List<AttachmentResource> resources) {
        return resources.stream().map(attachmentResource -> {
            AttachmentImpl attachment = (AttachmentImpl)this.taskService.newAttachment();
            BeanUtils.copyProperties((Object)attachmentResource, (Object)attachment);
            attachment.setId(attachmentResource.getAttachmentId());
            attachment.setClassificationSummary(this.classificationAssembler.toModel(attachmentResource.getClassificationSummary()));
            return attachment;
        }).collect(Collectors.toList());
    }
}

