/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.classification.internal.models.ClassificationImpl;
import pro.taskana.rest.ClassificationController;
import pro.taskana.rest.resource.ClassificationSummaryListResource;
import pro.taskana.rest.resource.ClassificationSummaryResource;
import pro.taskana.rest.resource.PagedResources;
import pro.taskana.rest.resource.links.PageLinks;

@Component
public class ClassificationSummaryResourceAssembler
extends ResourceAssemblerSupport<ClassificationSummary, ClassificationSummaryResource> {
    @Autowired
    private ClassificationService classificationService;

    public ClassificationSummaryResourceAssembler() {
        super(ClassificationController.class, ClassificationSummaryResource.class);
    }

    public ClassificationSummaryResource toResource(ClassificationSummary classificationSummary) {
        return new ClassificationSummaryResource(classificationSummary);
    }

    public ClassificationSummary toModel(ClassificationSummaryResource resource) {
        ClassificationImpl classification = (ClassificationImpl)this.classificationService.newClassification(resource.getKey(), resource.getDomain(), resource.getType());
        classification.setId(resource.getClassificationId());
        BeanUtils.copyProperties((Object)((Object)resource), (Object)classification);
        return classification.asSummary();
    }

    @PageLinks(value="/api/v1/classifications")
    public ClassificationSummaryListResource toResources(Collection<ClassificationSummary> entities, PagedResources.PageMetadata pageMetadata) {
        return new ClassificationSummaryListResource((Collection<ClassificationSummaryResource>)this.toResources(entities), pageMetadata, new Link[0]);
    }
}

