/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.util.List;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.DistributionTargetListResource;
import pro.taskana.rest.resource.DistributionTargetResource;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.WorkbasketSummary;

@Component
public class DistributionTargetResourceAssembler
extends ResourceAssemblerSupport<WorkbasketSummary, DistributionTargetResource> {
    public DistributionTargetResourceAssembler() {
        super(WorkbasketController.class, DistributionTargetResource.class);
    }

    public DistributionTargetResource toResource(WorkbasketSummary summary) {
        return new DistributionTargetResource(summary);
    }

    public DistributionTargetListResource toResources(String workbasketId, List<WorkbasketSummary> distributionTargets) throws WorkbasketNotFoundException, NotAuthorizedException {
        DistributionTargetListResource distributionTargetListResource = new DistributionTargetListResource(this.toResources(distributionTargets), new Link[0]);
        distributionTargetListResource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getDistributionTargets(workbasketId)).withSelfRel());
        distributionTargetListResource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasket(workbasketId)).withRel("workbasket"));
        return distributionTargetListResource;
    }
}

