/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;

public class PagedResources<T>
extends ResourceSupport {
    private Collection<T> content;
    private PageMetadata metadata;

    protected PagedResources() {
        this(new ArrayList(), null, new Link[0]);
    }

    public PagedResources(Collection<T> content, PageMetadata metadata, Link ... links) {
        this(content, metadata, Arrays.asList(links));
    }

    public PagedResources(Collection<T> content, PageMetadata metadata, Iterable<Link> links) {
        this.content = content;
        this.metadata = metadata;
        this.add(links);
    }

    @JsonProperty(value="page")
    public PageMetadata getMetadata() {
        if (Objects.isNull(this.metadata)) {
            Collection<T> content = this.getContent();
            return new PageMetadata(content.size(), 0L, content.size());
        }
        return this.metadata;
    }

    @JsonProperty(value="content")
    public Collection<T> getContent() {
        return Collections.unmodifiableCollection(this.content);
    }

    public static class PageMetadata {
        @XmlAttribute
        @JsonProperty
        private long size;
        @XmlAttribute
        @JsonProperty
        private long totalElements;
        @XmlAttribute
        @JsonProperty
        private long totalPages;
        @XmlAttribute
        @JsonProperty
        private long number;

        protected PageMetadata() {
        }

        public PageMetadata(long size, long number, long totalElements, long totalPages) {
            Assert.isTrue((size > -1L ? 1 : 0) != 0, (String)"Size must not be negative!");
            Assert.isTrue((number > -1L ? 1 : 0) != 0, (String)"Number must not be negative!");
            Assert.isTrue((totalElements > -1L ? 1 : 0) != 0, (String)"Total elements must not be negative!");
            Assert.isTrue((totalPages > -1L ? 1 : 0) != 0, (String)"Total pages must not be negative!");
            this.size = size;
            this.number = number;
            this.totalElements = totalElements;
            this.totalPages = totalPages;
        }

        public PageMetadata(long size, long number, long totalElements) {
            this(size, number, totalElements, size == 0L ? 0L : (long)Math.ceil((double)totalElements / (double)size));
        }

        public long getSize() {
            return this.size;
        }

        public long getTotalElements() {
            return this.totalElements;
        }

        public long getTotalPages() {
            return this.totalPages;
        }

        public long getNumber() {
            return this.number;
        }

        public int hashCode() {
            int result = 17;
            result += 31 * (int)(this.number ^ this.number >>> 32);
            result += 31 * (int)(this.size ^ this.size >>> 32);
            result += 31 * (int)(this.totalElements ^ this.totalElements >>> 32);
            return result += 31 * (int)(this.totalPages ^ this.totalPages >>> 32);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            PageMetadata that = (PageMetadata)obj;
            return this.number == that.number && this.size == that.size && this.totalElements == that.totalElements && this.totalPages == that.totalPages;
        }

        public String toString() {
            return String.format("Metadata { number: %d, total pages: %d, total elements: %d, size: %d }", this.number, this.totalPages, this.totalElements, this.size);
        }
    }
}

