/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.PagedResources;
import pro.taskana.rest.resource.WorkbasketAccessItemListResource;
import pro.taskana.rest.resource.WorkbasketAccessItemResource;
import pro.taskana.rest.resource.links.PageLinks;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.WorkbasketAccessItem;
import pro.taskana.workbasket.internal.models.WorkbasketAccessItemImpl;

@Component
public class WorkbasketAccessItemResourceAssembler
extends ResourceAssemblerSupport<WorkbasketAccessItem, WorkbasketAccessItemResource> {
    @Autowired
    private WorkbasketService workbasketService;

    public WorkbasketAccessItemResourceAssembler() {
        super(WorkbasketController.class, WorkbasketAccessItemResource.class);
    }

    public WorkbasketAccessItemResource toResource(WorkbasketAccessItem wbAccItem) {
        return new WorkbasketAccessItemResource(wbAccItem);
    }

    public WorkbasketAccessItem toModel(WorkbasketAccessItemResource wbAccItemResource) {
        WorkbasketAccessItemImpl wbAccItemModel = (WorkbasketAccessItemImpl)this.workbasketService.newWorkbasketAccessItem(wbAccItemResource.getWorkbasketId(), wbAccItemResource.getAccessId());
        BeanUtils.copyProperties((Object)((Object)wbAccItemResource), (Object)wbAccItemModel);
        wbAccItemModel.setId(wbAccItemResource.getAccessItemId());
        return wbAccItemModel;
    }

    @PageLinks(value="/api/v1/workbasket-access-items")
    public WorkbasketAccessItemListResource toResources(List<WorkbasketAccessItem> entities, PagedResources.PageMetadata pageMetadata) {
        return new WorkbasketAccessItemListResource(this.toResources(entities), pageMetadata, new Link[0]);
    }

    public WorkbasketAccessItemListResource toResources(String workbasketId, List<WorkbasketAccessItem> entities) throws NotAuthorizedException, WorkbasketNotFoundException {
        WorkbasketAccessItemListResource accessItemListResource = new WorkbasketAccessItemListResource(super.toResources(entities), null, new Link[0]);
        accessItemListResource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasketAccessItems(workbasketId)).withSelfRel());
        accessItemListResource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasket(workbasketId)).withRel("workbasket"));
        return accessItemListResource;
    }
}

