/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.time.Instant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.rest.WorkbasketController;
import pro.taskana.rest.resource.WorkbasketResource;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.internal.models.WorkbasketImpl;

@Component
public class WorkbasketResourceAssembler
extends ResourceAssemblerSupport<Workbasket, WorkbasketResource> {
    private final WorkbasketService workbasketService;

    @Autowired
    public WorkbasketResourceAssembler(WorkbasketService workbasketService) {
        super(WorkbasketController.class, WorkbasketResource.class);
        this.workbasketService = workbasketService;
    }

    public WorkbasketResource toResource(Workbasket wb) {
        try {
            WorkbasketResource resource = new WorkbasketResource(wb);
            return this.addLinks(resource, wb);
        }
        catch (Exception e) {
            throw new SystemException("caught unexpected Exception.", e.getCause());
        }
    }

    public Workbasket toModel(WorkbasketResource wbResource) {
        String wbKey = wbResource.getKey();
        String wbDomain = wbResource.getDomain();
        WorkbasketImpl workbasket = (WorkbasketImpl)this.workbasketService.newWorkbasket(wbKey, wbDomain);
        BeanUtils.copyProperties((Object)((Object)wbResource), (Object)workbasket);
        workbasket.setId(wbResource.getWorkbasketId());
        if (wbResource.getModified() != null) {
            workbasket.setModified(Instant.parse(wbResource.getModified()));
        }
        if (wbResource.getCreated() != null) {
            workbasket.setCreated(Instant.parse(wbResource.getCreated()));
        }
        return workbasket;
    }

    private WorkbasketResource addLinks(WorkbasketResource resource, Workbasket wb) throws NotAuthorizedException, WorkbasketNotFoundException, InvalidArgumentException {
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasket(wb.getId())).withSelfRel());
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getDistributionTargets(wb.getId())).withRel("distributionTargets"));
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbasketAccessItems(wb.getId())).withRel("accessItems"));
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).getWorkbaskets((MultiValueMap<String, String>)new LinkedMultiValueMap())).withRel("allWorkbaskets"));
        resource.add(ControllerLinkBuilder.linkTo(((WorkbasketController)ControllerLinkBuilder.methodOn(WorkbasketController.class, (Object[])new Object[0])).removeDistributionTargetForWorkbasketId(wb.getId())).withRel("removeDistributionTargets"));
        return resource;
    }
}

