/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.time.Instant;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.rest.TaskCommentController;
import pro.taskana.rest.resource.TaskCommentListResource;
import pro.taskana.rest.resource.TaskCommentResource;
import pro.taskana.rest.resource.links.PageLinks;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.task.internal.models.TaskCommentImpl;

@Component
public class TaskCommentResourceAssembler
extends ResourceAssemblerSupport<TaskComment, TaskCommentResource> {
    private final TaskService taskService;

    @Autowired
    public TaskCommentResourceAssembler(TaskService taskService) {
        super(TaskCommentController.class, TaskCommentResource.class);
        this.taskService = taskService;
    }

    public TaskCommentResource toResource(TaskComment taskComment) {
        TaskCommentResource taskCommentResource = new TaskCommentResource(taskComment);
        try {
            taskCommentResource.add(ControllerLinkBuilder.linkTo(((TaskCommentController)ControllerLinkBuilder.methodOn(TaskCommentController.class, (Object[])new Object[0])).getTaskComment(taskComment.getId())).withSelfRel());
        }
        catch (InvalidArgumentException | NotAuthorizedException | TaskCommentNotFoundException | TaskNotFoundException e) {
            throw new SystemException("caught unexpected Exception.", e.getCause());
        }
        return taskCommentResource;
    }

    @PageLinks(value="/api/v1/tasks/comments")
    public TaskCommentListResource toListResource(List<TaskComment> taskComments) {
        return new TaskCommentListResource(this.toResources(taskComments));
    }

    public TaskComment toModel(TaskCommentResource taskCommentResource) {
        TaskCommentImpl taskComment = (TaskCommentImpl)this.taskService.newTaskComment(taskCommentResource.getTaskId());
        taskComment.setId(taskCommentResource.getTaskCommentId());
        BeanUtils.copyProperties((Object)((Object)taskCommentResource), (Object)taskComment);
        if (taskCommentResource.getCreated() != null) {
            taskComment.setCreated(Instant.parse(taskCommentResource.getCreated()));
        }
        if (taskCommentResource.getModified() != null) {
            taskComment.setModified(Instant.parse(taskCommentResource.getModified()));
        }
        return taskComment;
    }
}

