/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest.resource;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.rest.resource.WorkbasketDefinitionResource;
import pro.taskana.rest.resource.WorkbasketResource;
import pro.taskana.rest.resource.WorkbasketResourceWithoutLinks;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketAccessItem;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.internal.models.WorkbasketAccessItemImpl;
import pro.taskana.workbasket.internal.models.WorkbasketImpl;

@Component
public class WorkbasketDefinitionResourceAssembler {
    @Autowired
    private WorkbasketService workbasketService;

    public WorkbasketDefinitionResource toResource(Workbasket workbasket) throws NotAuthorizedException, WorkbasketNotFoundException {
        WorkbasketResourceWithoutLinks basket = new WorkbasketResourceWithoutLinks(workbasket);
        ArrayList<WorkbasketAccessItemImpl> authorizations = new ArrayList<WorkbasketAccessItemImpl>();
        for (WorkbasketAccessItem accessItem : this.workbasketService.getWorkbasketAccessItems(basket.getWorkbasketId())) {
            authorizations.add((WorkbasketAccessItemImpl)accessItem);
        }
        Set<String> distroTargets = this.workbasketService.getDistributionTargets(workbasket.getId()).stream().map(WorkbasketSummary::getId).collect(Collectors.toSet());
        return new WorkbasketDefinitionResource(basket, distroTargets, authorizations);
    }

    public Workbasket toModel(WorkbasketResource wbResource) {
        WorkbasketImpl workbasket = (WorkbasketImpl)this.workbasketService.newWorkbasket(wbResource.getKey(), wbResource.getDomain());
        BeanUtils.copyProperties((Object)((Object)wbResource), (Object)workbasket);
        workbasket.setId(wbResource.getWorkbasketId());
        if (wbResource.getModified() != null) {
            workbasket.setModified(Instant.parse(wbResource.getModified()));
        }
        if (wbResource.getCreated() != null) {
            workbasket.setCreated(Instant.parse(wbResource.getCreated()));
        }
        return workbasket;
    }
}

