/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.rest;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.rest.resource.TaskCommentListResource;
import pro.taskana.rest.resource.TaskCommentResource;
import pro.taskana.rest.resource.TaskCommentResourceAssembler;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.TaskComment;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskCommentController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskCommentController.class);
    private TaskService taskService;
    private TaskCommentResourceAssembler taskCommentResourceAssembler;

    TaskCommentController(TaskService taskService, TaskCommentResourceAssembler taskCommentResourceAssembler) {
        this.taskService = taskService;
        this.taskCommentResourceAssembler = taskCommentResourceAssembler;
    }

    @GetMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentResource> getTaskComment(@PathVariable String taskCommentId) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getTaskComment(taskCommentId= {})", (Object)taskCommentId);
        }
        TaskComment taskComment = this.taskService.getTaskComment(taskCommentId);
        TaskCommentResource taskCommentResource = this.taskCommentResourceAssembler.toResource(taskComment);
        ResponseEntity response = ResponseEntity.ok((Object)((Object)taskCommentResource));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTaskComment(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/tasks/{taskId}/comments"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentListResource> getTaskComments(@PathVariable String taskId) throws NotAuthorizedException, TaskNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to getTaskComments(taskId= {})", (Object)taskId);
        }
        List taskComments = this.taskService.getTaskComments(taskId);
        TaskCommentListResource taskCommentListResource = this.taskCommentResourceAssembler.toListResource(taskComments);
        ResponseEntity response = ResponseEntity.ok((Object)((Object)taskCommentListResource));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getTaskComments(), returning {}", (Object)response);
        }
        return response;
    }

    @DeleteMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentResource> deleteTaskComment(@PathVariable String taskCommentId) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to deleteTaskComment(taskCommentId= {})", (Object)taskCommentId);
        }
        this.taskService.deleteTaskComment(taskCommentId);
        ResponseEntity result = ResponseEntity.noContent().build();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from deleteTaskComment(), returning {}", (Object)result);
        }
        return result;
    }

    @PutMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentResource> updateTaskComment(@PathVariable String taskCommentId, @RequestBody TaskCommentResource taskCommentResource) throws NotAuthorizedException, TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException, ConcurrencyException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to updateTaskComment(taskCommentId= {}, taskCommentResource= {})", (Object)taskCommentId, (Object)taskCommentResource);
        }
        ResponseEntity result = null;
        if (!taskCommentId.equals(taskCommentResource.getTaskCommentId())) {
            throw new InvalidArgumentException(String.format("TaskCommentId ('%s') is not identical with the id of the object in the payload which should be updated", taskCommentId));
        }
        TaskComment taskComment = this.taskCommentResourceAssembler.toModel(taskCommentResource);
        taskComment = this.taskService.updateTaskComment(taskComment);
        result = ResponseEntity.ok((Object)((Object)this.taskCommentResourceAssembler.toResource(taskComment)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from updateTaskComment(), returning {}", (Object)result);
        }
        return result;
    }

    @PostMapping(path={"/api/v1/tasks/{taskId}/comments"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentResource> createTaskComment(@PathVariable String taskId, @RequestBody TaskCommentResource taskCommentResource) throws NotAuthorizedException, InvalidArgumentException, TaskNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entry to createTaskComment(taskId= {}, taskCommentResource= {})", (Object)taskId, (Object)taskCommentResource);
        }
        taskCommentResource.setTaskId(taskId);
        TaskComment taskCommentFromResource = this.taskCommentResourceAssembler.toModel(taskCommentResource);
        TaskComment createdTaskComment = this.taskService.createTaskComment(taskCommentFromResource);
        ResponseEntity result = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)this.taskCommentResourceAssembler.toResource(createdTaskComment));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from createTaskComment(), returning {}", (Object)result);
        }
        return result;
    }
}

