/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.hateoas.PagedModel;
import org.springframework.util.MultiValueMap;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.InvalidArgumentException;

public abstract class AbstractPagingController {
    private static final String PAGING_PAGE = "page";
    private static final String PAGING_PAGE_SIZE = "page-size";

    protected String[] extractCommaSeparatedFields(List<String> list) {
        ArrayList values = new ArrayList();
        if (list != null) {
            list.forEach(item -> values.addAll(Arrays.asList(item.split(","))));
        }
        return values.toArray(new String[0]);
    }

    protected void validateNoInvalidParameterIsLeft(MultiValueMap<String, String> params) throws InvalidArgumentException {
        if (!params.isEmpty()) {
            throw new InvalidArgumentException("Invalid parameter specified: " + params.keySet());
        }
    }

    protected PagedModel.PageMetadata getPageMetadata(MultiValueMap<String, String> params, BaseQuery<?, ?> query) throws InvalidArgumentException {
        PagedModel.PageMetadata pageMetadata = null;
        if (this.hasPagingInformationInParams(params)) {
            long totalElements = query.count();
            pageMetadata = this.initPageMetadata(params, totalElements);
            this.validateNoInvalidParameterIsLeft(params);
        } else {
            this.validateNoInvalidParameterIsLeft(params);
        }
        return pageMetadata;
    }

    protected <T> List<T> getQueryList(BaseQuery<T, ?> query, PagedModel.PageMetadata pageMetadata) {
        List resultList = pageMetadata != null ? query.listPage((int)pageMetadata.getNumber(), (int)pageMetadata.getSize()) : query.list();
        return resultList;
    }

    protected PagedModel.PageMetadata initPageMetadata(MultiValueMap<String, String> param, long totalElements) throws InvalidArgumentException {
        long page;
        long pageSize = this.getPageSize(param);
        PagedModel.PageMetadata pageMetadata = new PagedModel.PageMetadata(pageSize, page = this.getPage(param), totalElements >= 0L ? totalElements : Integer.MAX_VALUE);
        if (pageMetadata.getNumber() > pageMetadata.getTotalPages()) {
            pageMetadata = new PagedModel.PageMetadata(pageSize, pageMetadata.getTotalPages(), totalElements);
        }
        return pageMetadata;
    }

    protected PagedModel.PageMetadata initPageMetadata(String pagesizeParam, String pageParam, long totalElements) throws InvalidArgumentException {
        long page;
        long pageSize;
        try {
            pageSize = Long.parseLong(pagesizeParam);
            page = Long.parseLong(pageParam);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("page and pageSize must be a integer value.", e.getCause());
        }
        PagedModel.PageMetadata pageMetadata = new PagedModel.PageMetadata(pageSize, page, totalElements);
        if (pageMetadata.getNumber() > pageMetadata.getTotalPages()) {
            pageMetadata = new PagedModel.PageMetadata(pageSize, pageMetadata.getTotalPages(), totalElements);
        }
        return pageMetadata;
    }

    private boolean hasPagingInformationInParams(MultiValueMap<String, String> params) {
        return params.getFirst((Object)PAGING_PAGE) != null;
    }

    private long getPage(MultiValueMap<String, String> params) throws InvalidArgumentException {
        String param = (String)params.getFirst((Object)PAGING_PAGE);
        params.remove((Object)PAGING_PAGE);
        try {
            return Long.parseLong(param != null ? param : "1");
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("page must be a integer value.", e.getCause());
        }
    }

    private long getPageSize(MultiValueMap<String, String> params) throws InvalidArgumentException {
        String param = (String)params.getFirst((Object)PAGING_PAGE_SIZE);
        params.remove((Object)PAGING_PAGE_SIZE);
        try {
            return param != null ? Long.parseLong(param) : Integer.MAX_VALUE;
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("page-size must be a integer value.", e.getCause());
        }
    }
}

