/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.rest.ldap.LdapClient;
import pro.taskana.common.rest.models.AccessIdRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class AccessIdController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessIdController.class);
    LdapClient ldapClient;

    @Autowired
    public AccessIdController(LdapClient ldapClient) {
        this.ldapClient = ldapClient;
    }

    @GetMapping(path={"/api/v1/access-ids"})
    public ResponseEntity<List<AccessIdRepresentationModel>> validateAccessIds(@RequestParam(value="search-for") String searchFor) throws InvalidArgumentException {
        LOGGER.debug("Entry to validateAccessIds(search-for= {})", (Object)searchFor);
        if (searchFor.length() < this.ldapClient.getMinSearchForLength()) {
            throw new InvalidArgumentException("searchFor string '" + searchFor + "' is too short. Minimum searchFor length = " + this.ldapClient.getMinSearchForLength());
        }
        List<AccessIdRepresentationModel> accessIdUsers = this.ldapClient.searchUsersAndGroups(searchFor);
        ResponseEntity response = ResponseEntity.ok(accessIdUsers);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from validateAccessIds(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/access-ids/groups"})
    public ResponseEntity<List<AccessIdRepresentationModel>> getGroupsByAccessId(@RequestParam(value="access-id") String accessId) throws InvalidArgumentException {
        LOGGER.debug("Entry to getGroupsByAccessId(access-id= {})", (Object)accessId);
        if (!this.validateAccessId(accessId)) {
            throw new InvalidArgumentException("The accessId is invalid");
        }
        List<AccessIdRepresentationModel> accessIdUsers = this.ldapClient.searchUsersAndGroups(accessId);
        accessIdUsers.addAll(this.ldapClient.searchGroupsofUsersIsMember(accessId));
        ResponseEntity response = ResponseEntity.ok(accessIdUsers);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getGroupsByAccessId(), returning {}", (Object)response);
        }
        return response;
    }

    private boolean validateAccessId(String accessId) throws InvalidArgumentException {
        return this.ldapClient.searchUsersAndGroups(accessId).size() == 1;
    }
}

