/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.internal.security.CurrentUserContext;
import pro.taskana.common.rest.models.TaskanaUserInfoRepresentationModel;
import pro.taskana.common.rest.models.VersionRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskanaEngineController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineController.class);
    private final TaskanaEngineConfiguration taskanaEngineConfiguration;
    private final TaskanaEngine taskanaEngine;
    @Value(value="${version:Local build}")
    private String version;

    TaskanaEngineController(TaskanaEngineConfiguration taskanaEngineConfiguration, TaskanaEngine taskanaEngine) {
        this.taskanaEngineConfiguration = taskanaEngineConfiguration;
        this.taskanaEngine = taskanaEngine;
    }

    @GetMapping(path={"/api/v1/domains"})
    public ResponseEntity<List<String>> getDomains() {
        ResponseEntity response = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getDomains());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getDomains(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/classification-categories"})
    public ResponseEntity<List<String>> getClassificationCategories(String type) {
        LOGGER.debug("Entry to getClassificationCategories(type = {})", (Object)type);
        if (type != null) {
            ResponseEntity response = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getClassificationCategoriesByType(type));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from getClassificationCategories(), returning {}", (Object)response);
            }
            return response;
        }
        ResponseEntity response = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getAllClassificationCategories());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getClassificationCategories(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/classification-types"})
    public ResponseEntity<List<String>> getClassificationTypes() {
        ResponseEntity response = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getClassificationTypes());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getClassificationTypes(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/classifications-by-type"})
    public ResponseEntity<Map<String, List<String>>> getClassificationCategoriesByTypeMap() {
        ResponseEntity response = ResponseEntity.ok((Object)this.taskanaEngineConfiguration.getClassificationCategoriesByTypeMap());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getClassificationCategoriesByTypeMap(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/current-user-info"})
    public ResponseEntity<TaskanaUserInfoRepresentationModel> getCurrentUserInfo() {
        LOGGER.debug("Entry to getCurrentUserInfo()");
        TaskanaUserInfoRepresentationModel resource = new TaskanaUserInfoRepresentationModel();
        resource.setUserId(CurrentUserContext.getUserid());
        resource.setGroupIds(CurrentUserContext.getGroupIds());
        for (TaskanaRole role : this.taskanaEngineConfiguration.getRoleMap().keySet()) {
            if (!this.taskanaEngine.isUserInRole(new TaskanaRole[]{role})) continue;
            resource.getRoles().add(role);
        }
        ResponseEntity response = ResponseEntity.ok((Object)((Object)resource));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from getCurrentUserInfo(), returning {}", (Object)response);
        }
        return response;
    }

    @GetMapping(path={"/api/v1/history-provider-enabled"})
    public ResponseEntity<Boolean> getIsHistoryProviderEnabled() {
        ResponseEntity response = ResponseEntity.ok((Object)this.taskanaEngine.isHistoryEnabled());
        LOGGER.debug("Exit from getIsHistoryProviderEnabled(), returning {}", (Object)response);
        return response;
    }

    @GetMapping(path={"/api/v1/version"})
    public ResponseEntity<VersionRepresentationModel> currentVersion() {
        LOGGER.debug("Entry to currentVersion()");
        VersionRepresentationModel resource = new VersionRepresentationModel();
        resource.setVersion(TaskanaEngineConfiguration.class.getPackage().getImplementationVersion());
        ResponseEntity response = ResponseEntity.ok((Object)((Object)resource));
        LOGGER.debug("Exit from currentVersion(), returning {}", (Object)response);
        return response;
    }
}

